function openrawdata(inputfilename);

%   openrawdata


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

global datamat NChan NTotChan NPoints NEvents datamat NChan NEvents MaxSizePoints datatmpfile nrsegment segment
actualpath=pwd;
if nargin<4; Sample=[]; end;
if nargin<3; MaxMemory=10; end;
if nargin<2; TRStatus=[]; end;
if nargin<1; FileMat=[]; end;
global NChan
%read rawfile
%--------------
if exist('eegviewerpaths.mat')~=0
    load('eegviewerpaths.mat','rawfilepath');
    if ~isempty(rawfilepath) & ~(rawfilepath==0) & exist(rawfilepath)>0
         cd(rawfilepath);
    end
end
if nargin<1
	[rawfilename,rawfilepath]=uigetfile('*.*','Please choose raw-data-file:');
	if isequal(rawfilename,0)|isequal(rawfilepath,0)
       uiwait(msgbox('File not found'));
       return
	end
	pplibpath = which('pp.m');
	filesepvec=findstr(filesep,pplibpath);
	save([pplibpath(1:filesepvec(end)),'eegviewerpaths.mat'],'rawfilepath');
	cd(actualpath);
    filemenu=findobj('tag','filemenu');
    rawfile=[rawfilepath,rawfilename];
    filepathmenuitem=uimenu(filemenu,'Label',rawfile,'Callback',['openrawdata(',char(39),rawfile,char(39),')']);
   
else
    rawfile=inputfilename;
end



RAWFid=fopen(rawfile,'r','b');
fseek(RAWFid,22,-1);
NChan=fread(RAWFid,1,'short');
fseek(RAWFid,6,0);
NPoints=fread(RAWFid,1,'long');
NEvents=fread(RAWFid,1,'short');
NTotChan=NChan+NEvents;
fseek(RAWFid,NEvents.*4,0);
LHeader=ftell(RAWFid);
LRawFile=LHeader+NTotChan.*NPoints.*2;
fseek(RAWFid,0,-1);
Header=[];
Header=fread(RAWFid,LHeader,'int8');	
MaxSizePoints=floor(MaxMemory.*1000000./(NTotChan.*8));
NLoops=max([1,floor((NPoints./MaxSizePoints))]);
RestPoints=NPoints-NLoops.*MaxSizePoints;


statustext1=findobj('Tag','statustext1');
pause(0.1);
if NLoops==1
	[datamat,Count]=fread(RAWFid,[NTotChan,NPoints],'int16');
	if Count~=NTotChan.*NPoints; error('Count~=NTotChan.*NPoints in TransRawTaw'); end
else
	fseek(RAWFid,LHeader,-1);
	datamat=[];
	ZeroVec=zeros(NPoints-MaxSizePoints,1);
	for LoopInd=1:NLoops
		set(statustext1,'String',[num2str(LoopInd),' of ',num2str(NLoops),' loops done...']);
        datamattmp=[];
		datamattmp=fread(RAWFid,[NTotChan,MaxSizePoints],'int16');
        datamat=[datamat,datamattmp];
	end
	if RestPoints>0
        datamattmp=[];
		datamattmp=fread(RAWFid,[NTotChan,RestPoints],'int16');
        datamat=[datamat,datamattmp];
	end
end
fclose(RAWFid);
set(statustext1,'String','');
TimePoints=size(datamat,2);
statustext2=findobj('Tag','statustext2');
set(statustext2,'String',[num2str(TimePoints),' points']);
statustext3=findobj('Tag','statustext3');
set(statustext3,'String',[num2str(NChan),' channels']);


% %debug
% datamat=datamattmp;
% NPoints=size(datamat,2);


%vertikale Gesamt-Hhe: 0.139 bis 0.98 -> 0.8410
toplimit=0.98;
bottomlimit=0.139;
height=0.8410;
%horizontale Gesamt-Breite: 0.0268 bis 0.9604 ---> 0.9336
leftlimit=0.0268;
rightlimit=0.9604;
width=0.9336;

channelscalingslider=findobj('tag','channelscalingslider');
set(channelscalingslider,'Min',1);
set(findobj('tag','channelscalingslider'),'Max',NChan);
set(findobj('tag','channelscalingslider'),'Value',get(channelscalingslider,'Max'));
channelscaling=get(channelscalingslider,'Value');

channelwindowslider=findobj('tag','channelwindowslider');
set(channelwindowslider,'Max',NChan/channelscaling);
set(channelwindowslider,'Min',-NChan/channelscaling);
set(channelwindowslider,'Value',get(channelwindowslider,'Max'));

timescalingslider=findobj('tag','timescalingslider');
set(findobj('tag','timescalingslider'),'Min',MaxSizePoints/1000);
set(findobj('tag','timescalingslider'),'Max',MaxSizePoints/50);
set(findobj('tag','timescalingslider'),'Value',MaxSizePoints/1000);
timescaling=get(timescalingslider,'Value');

timewindowslider=findobj('tag','timewindowslider');
set(timewindowslider,'Min',0);
set(timewindowslider,'Max',timescaling-1);
set(timewindowslider,'Value',get(timewindowslider,'Min'));

ampscalingslider=findobj('tag','ampscalingslider');
set(ampscalingslider,'Value',get(ampscalingslider,'Max'));

nrsegment=ceil(NPoints/MaxSizePoints);
segment=1;

eegviewerpath=which('eegviewer.m');
filesepvec=findstr(eegviewerpath,filesep);
eegviewerpath=eegviewerpath(1:filesepvec(end));
datatmpfile=[eegviewerpath,'datatmp.mat'];
save(datatmpfile,'datamat');

plotrawdata;


return