function plotrawdata
%   plotrawdata

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

global axeshandles ampscaling channelwindow channelscaling timewindow timescaling lowerlimit...
    axeswidth axesheight axesx datamat NChan NPoints NEvents MaxSizePoints channelnumberlabels...
    vertposvecini bottomstandoff topstandoff segment nrsegment
lowerlimit=0.12;

channelscalingslider=findobj('tag','channelscalingslider');
channelwindowslider=findobj('tag','channelwindowslider');
timescalingslider=findobj('tag','timescalingslider');
ampscalingslider=findobj('tag','ampscalingslider');
timewindowslider=findobj('tag','timewindowslider');

timewindow=get(findobj('tag','timewindowslider'),'Value');
channelscaling=get(findobj('tag','channelscalingslider'),'Value');
timescaling=get(findobj('tag','timescalingslider'),'Value');
ampscaling=get(findobj('tag','ampscalingslider'),'Value');
channelwindow=get(findobj('tag','channelwindowslider'),'Value');
eegviewerfig=findobj('tag','eegviewer');
figure(eegviewerfig);
  
%positioning
%-----------
%vertikale Gesamt-Hhe: 0.139 bis 0.98 -> 0.8410
toplimit=0.98;
bottomlimit=0.139;
height=0.8410;
%horizontale Gesamt-Breite: 0.0268 bis 0.9604 ---> 0.9336
% leftlimit=0.0268;
leftlimit=0.168;
rightlimit=0.9604;
width=0.9336;
%horizontal resolution: maximum axes width 10pts/screenwidth
maxres=size(datamat,2)/100;
%axes heights: 
axesheight=height/(NChan*ampscaling*ampscaling);
%axes widths: 
axeswidth=width*timescaling;
%axes vertical pos: 
%axesy = toplimit - j*height*channelscaling-axesheight/2 + channelwindow*axesheight
%axes horizontal pos:
axesx=leftlimit-width*timewindow;

figurecolor=get(gcf,'Color');

%create axes
%-----------------------
ax=findobj('type','axes');
delete(ax);
vertposvec=[];


%plot data
%----------
if size(datamat(1,(segment-1)*MaxSizePoints+1:end),2)>MaxSizePoints
    datamattoplot=datamat(:,(segment-1)*MaxSizePoints+1:segment*MaxSizePoints);
else
    datamattoplot=datamat(:,(segment-1)*MaxSizePoints+1:end);
end

%timeaxes
%-----------
timeaxes=axes('units','normalized','tag','timeaxes','position',[0.023192360163710776 0.08111111111111111 0.9413369713506139 0.056530214424951264],'YColor',[1 1 1],'fontsize',6);
timeaxes=findobj('tag','timeaxes');
%channelnumberaxes
%------------------
channelnumberaxes=axes('units','normalized','tag','channelnumberaxes','position',[0.0 0 0.04435006435006435 1],'XLim',[0 1],'YLim',[0 1],'Visible','on','fontsize',4,'YColor',figurecolor);

yrange=std(datamat(1,:));

for j=1:NChan
    hold on
    axeshandles(j)=axes('units','normalized','tag',['Chan',num2str(j)],...
    'position',[axesx  (toplimit - j*height/channelscaling  - channelwindow*height/channelscaling) axeswidth axesheight]);
    plot(datamattoplot(j,:));
    hold off
    set(gca,'Color','none','XTick',[],'YTick',[],'XTickLabel','','YTickLabel','','XColor',[0 0 0],'Ylim',[mean(datamat(j,:))-6*yrange,mean(datamat(j,:))+6*yrange],...
    'YColor',[0 0 0],'XColor',figurecolor,'Color',figurecolor,'box','off','XLim',[0 size(datamattoplot,2)],'units','normalized');   
    vertposvec(j)=(toplimit - j*height/channelscaling - channelwindow*height/channelscaling + 0.5*axesheight);
    channelnumberaxes=findobj('tag','channelnumberaxes');
    axes(channelnumberaxes);
    hold on
    channelnumberlabels(j)=text(0.65,vertposvec(j),num2str(j),'color',[0 0 0],'HorizontalAlignment','center','fontsize',8);  
    hold off
end
vertposvecini=vertposvec;
bottomstandoff=min(vertposvec);
topstandoff=1-max(vertposvec);


return