function randomizefenster(filename,filepath,mode)

%   randomizefenster
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.    


global faktorstring stufenvec aktiverfaktor gradientcell stufenvec widmat ausschlussmat
faktorstring=cell(1,1);
stufenvec=zeros(3,1);
aktiverfaktor=1;
gradientcell=cell(1,1);
widmat=[];
ausschlussmat=[];

%fenster
randomizewindow = figure('MenuBar','none', ...
    'Units','points', ...
	'Color',[0.8 0.8 0.8], ...
	'Position',[364.5 156.25 161.25 264.25], ...
    'Tag','randomizefenster',...
    'Name','Randomizer', ...
    'NumberTitle','off');
%farbiger frame
frame = uicontrol('Parent',randomizewindow, ...
	'Units','points', ...   
	'BackgroundColor',[0.8 1 0.8], ...
	'FontSize',14, ...
	'HorizontalAlignment','left', ...
	'Position',[0 0 300 720], ...
	'Style','text', ...
	'Tag','StaticText4');


%faktorenanzahl
faktorenlabel = uicontrol('Parent',randomizewindow, ...
	'Units','points', ...
	'BackgroundColor',[0.8 1 0.8], ...
	'Position',[8 225.75 80.75 20.25], ...
	'String','Anzahl der Faktoren:', ...
	'Style','text', ...
    'Tag','StaticText1');
faktorenedit = uicontrol('parent',randomizewindow,...
    'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[105.75 230.75 40.75 16.5], ...
	'Style','edit', ...
    'Tag','faktorenedit', ...
    'Callback','[faktorstring]=updatefaktorstufenmenu;',...
    'Value',[1]);
%aktiverfaktor
faktorauswahllabel = uicontrol('Parent',randomizewindow, ...
	'Units','points', ...
	'BackgroundColor',[0.8 1 0.8], ...
	'Position',[9 205.75 55.75 20.25], ...
	'String','Faktorauswahl:', ...
	'Style','text', ...
    'Tag','StaticText1');
faktorstufenmenu = uicontrol('parent',randomizewindow,...
   'Units','points', ...
   'BackgroundColor',[1 1 1], ...
   'Position',[8.75 190.75 138 16.5], ...
   'Style','popupmenu', ...
   'Tag','faktorauswahl', ...
   'String','faktor1',...
   'Callback','[aktiverfaktor]=set_aktiver_faktor;',...
   'Max',4,...
   'Value',1);

%faktorstufen
stufenlabel = uicontrol('Parent',randomizewindow, ...
	'Units','points', ...
	'BackgroundColor',[0.8 1 0.8], ...
	'Position',[8.75 155.75 30.75 20.25], ...
	'String','Stufen:', ...
	'Style','text', ...
    'Tag','StaticText1');
stufenedit = uicontrol('parent',randomizewindow,...
   'Units','points', ...
   'BackgroundColor',[1 1 1], ...
   'Position',[8.75 141.75 40.75 16.5], ...
   'Style','edit', ...
   'Tag','stufenedit', ...
   'Callback','[stufenvec,faktorstring]=updatestufen(stufenvec,faktorstring,aktiverfaktor);',...
   'Value',1);

%gradient
gradientlabel = uicontrol('Parent',randomizewindow, ...
	'Units','points', ...
	'BackgroundColor',[0.8 1 0.8], ...
	'Position',[80 155.75 70.75 20.25], ...
	'String','Stimulianzahl[]:', ...
	'Style','text', ...
    'Tag','StaticText1');
gradientedit = uicontrol('parent',randomizewindow,...
   'Units','points', ...
   'BackgroundColor',[1 1 1], ...
   'Position',[85.75 141.75 60.75 16.5], ...
   'Style','edit', ...
   'Tag','gradientedit', ...
   'Callback','[gradientcell,faktorstring]=updategradient(gradientcell,faktorstring,aktiverfaktor);',...
   'Value',1);

%signallaenge
signallaengelabel = uicontrol('Parent',randomizewindow, ...
	'Units','points', ...
	'BackgroundColor',[0.8 1 0.8], ...
	'Position',[9 40.75 55.75 20.25], ...
	'String','Signallaenge:', ...
	'Style','text', ...
    'Tag','signallaengelabel');
signallaengeedit = uicontrol('parent',randomizewindow,...
    'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[85.75 45.75 60.75 16.5], ...
	'Style','text', ...
    'Enable','on',...
    'Tag','signallaengeedit', ...
    'Value',1);
%ausschluss
ausschlussradio = uicontrol('Parent',randomizewindow, ...
	'Units','points', ...
	'BackgroundColor',[0.8 1 0.8], ...
	'Position',[8.75 75.75 70.75 16.5], ...
	'String','Ausschluss:', ...
	'Style','radio', ...
    'Callback','enableausschlussedit',...
   'Tag','ausschlussradio');
ausschlussedit = uicontrol('parent',randomizewindow,...
   'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[105.75 75 40.75 16.5], ...
	'Style','edit', ...
    'Enable','off',...
    'Callback','updateausschluss;',...
   'Tag','ausschlussedit', ...
   'Value',[0]);

wiederholungradio = uicontrol('Parent',randomizewindow, ...
	'Units','points', ...
	'BackgroundColor',[0.8 1 0.8], ...
	'Position',[8.75 105.75 80.75 16.5], ...
	'String','Wiederholungen:', ...
    'Callback','enablewiederholungsedit',...
	'Style','radio', ...
   'Tag','wiederholungsradio');
wiederholungedit = uicontrol('parent',randomizewindow,...
   'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[105.75 105.95 40.75 16.5], ...
	'Style','edit', ...
    'Enable','off',...
   'Tag','wiederholungsedit', ...
   'Callback','updatewiederholung;',...
   'Value',[0]);

f = uicontrol('Parent',randomizewindow, ...
	'Units','points', ...
	'Position',[9 10.5 58.5 26.25], ...
	'String','abbrechen', ...
   'Tag','Pushbutton1', ...
	'Callback','close'); 
g = uicontrol('Parent',randomizewindow, ...
	'Units','points', ...
	'Position',[85.5 10.5 60.25 26.25], ...
	'String','ok', ...
   'Tag','Pushbutton2',...
	'Callback','engagerandomize;'); 



