function randomizemain

%   randomizemain

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 
                                                                    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global uewktmat reihe bestreihe bestuewktmat bestdist anzahlfaktoren stufenvec ...
    signallaenge relmat widmat wktstatus whlstatus whlspez uewktoptstatus gradientcell ausschlussmat faktorausschluss

bestdiff=100;bestreihe=[];distmat=[];kriterium=20;bestdist=1000;punktzaehler=1;neumat=[];dist=2000;
sternzaehler=1;bigpointzaehler=0;uematzaehler=1;zwischenspeicher=[];avgzaehler=1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                   %
% ohne Wiederholung (Faktorwiederholung), gleichverteilt, kein Ausschluss                %
%                                                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



if strcmp(wktstatus,'j') & faktorausschluss==0 & size(stufenvec,1) <=2
 
%Elementanzahl bestimmen  
anzahlelemente1 = stufenvec(1,1);

if size(stufenvec,1)>1
    anzahlelemente2 = stufenvec(2,1);
else
    anzahlelemente2 = 1;
end


anzahlelemente=anzahlelemente1*anzahlelemente2;
if anzahlelemente1==1
    restanzahl=(anzahlelemente2-1);
elseif anzahlelemente2==1
    restanzahl=(anzahlelemente1-1);  
else
    restanzahl=(anzahlelemente1-1)*(anzahlelemente2-1);
end
 
if ~(rem(signallaenge,anzahlelemente)==0   &    rem(signallaenge,restanzahl)==0)
    errordlg(['Bei dieser Option ohne Wiederholung muss die Signallaenge ein gemeinsames Vielfaches von ',num2str(restanzahl),' und ',num2str(anzahlelemente),' sein (z.B.',num2str(restanzahl*anzahlelemente*2),' oder ',num2str(restanzahl*anzahlelemente*10),')! Der Vorgang wird abgebrochen!'],'Achtung:');
    return;
end

%koordinaten umrechnen
zaehlmat=(linspace(1,anzahlelemente1,anzahlelemente1))';
for q=2:anzahlelemente2
   zaehlmat=[zaehlmat,(linspace(1,anzahlelemente1,anzahlelemente1)+(q-1)*anzahlelemente1)'];
end

%Folgeelementmatrix bestimmen (pro Zeile alle mglichen Folgeelemente auf Zeilennummer)
    alternativen=zeros(anzahlelemente,restanzahl);
    for dings=1:anzahlelemente
        altindices=(find(zaehlmat>0))';
        gleichespalte=find(and(altindices>anzahlelemente1*floor(zaehlmat(dings)/(anzahlelemente1+0.00001)),altindices<=anzahlelemente1+anzahlelemente1*floor(zaehlmat(dings)/(anzahlelemente1+0.00001))));  
        gleichezeile=find(rem(altindices,anzahlelemente1)==rem(zaehlmat(dings),anzahlelemente1));
        anzahlspaltindices=size(gleichespalte);
        anzahlzeilindices=size(gleichezeile);
        equalindices=zeros(anzahlspaltindices(2),anzahlzeilindices(2));
        for t=1:anzahlspaltindices(2)
             equalindices(t,:)=(gleichespalte(t)==gleichezeile);
        end
        [equalspaltindices,equalzeilindices]=find(equalindices==1);
        gleichespalte(equalspaltindices)=[];
        if and(anzahlelemente1~=1,anzahlelemente2~=1)
            altindices([gleichespalte gleichezeile])=[];
        elseif anzahlelemente1==1
            altindices(gleichespalte)=[];
        elseif anzahlelemente2==1
            altindices(gleichezeile)=[];
        end
        for bums=1:restanzahl
      	    alternativen(dings,bums)=zaehlmat(altindices(bums));
        end
        alternativen(dings,:)=alternativen(dings,:);
    end

%optimierungsmatritzen erstellen   
sumvec=zeros(1,anzahlelemente);
negeyemat=-eye(anzahlelemente)+ones(anzahlelemente);
idvec=zeros(1,anzahlelemente);

if anzahlelemente2==1
    erwartungswert=signallaenge/((anzahlelemente1)*(anzahlelemente1-1));
    erwartungsmat=ones(anzahlelemente)*erwartungswert;
    for a=1:anzahlelemente
        erwartungsmat(a,a)=0;
    end
else
    erwartungswert=signallaenge/(anzahlelemente*restanzahl);
    erwartungsmat=zeros(anzahlelemente);
    for a=1:anzahlelemente
        for b=1:restanzahl
        erwartungsmat(a,alternativen(a,b))=erwartungswert;
        end
    end
end
 
if strcmp(uewktoptstatus,'n')

%Reihe mit choicemat und Folgematrix erstellen und anzahl prfen bis anzahl gleichverteilt
intervall=(signallaenge/restanzahl);
while sum(idvec)<anzahlelemente
   
        %choicemat erstellen (Reihe mit Nummer des Folgeelements (choicematwert ist Spaltenindex der Folgematrix)
        choicemat=(randperm(signallaenge))'; 
        for w=1:anzahlelemente
            indices=and(choicemat>intervall*(w-1),choicemat<=intervall+intervall*(w-1));
            choicemat(indices,1)=w;
        end
        
        %anzahl der elemente in choicemat berprfen
        choicematsumvec=zeros(1,restanzahl);
        for n=1:restanzahl
            choicematsumvec(1,n)=sum(sum(choicemat==n));
        end
        
        %reihe schreiben
        reihe=zeros(1,signallaenge);
        reihe(1,1)=choicemat(1,1);
        for k=2:signallaenge
            reihe(1,k)=alternativen(reihe(1,k-1),choicemat(k,1));
        end

        %anzahl berprfen
        for n=1:anzahlelemente
            sumvec(1,n)=sum(reihe==n);
            idvec=(sumvec(1,1)==sumvec);
        end
        
        fprintf('*');
		sternzaehler=sternzaehler+1;
		if mod(sternzaehler,20)==0
            fprintf('\n');
		end
        
        if mod(sternzaehler,200)==0
            antwort=questdlg('Weitersuchen?',...
            'Optimierung:',...
            'ja','nein','ja');
                if strcmp(antwort,'nein')
                return;
            end
        end     
        pause(0.0005);
        
     
end
reihe=reihe';

%Uebergangswahrscheinlichkeiten
anzahlmat=zeros(signallaenge,anzahlelemente);
for u=1:anzahlelemente
anzahlmat(:,u)=(u==reihe(:,1));
end	
anzahlvec=sum(anzahlmat);
equalvec=(anzahlvec(1)==anzahlvec);
uewktmat=zeros(anzahlelemente);
for l=1:(signallaenge-1)
   for m=1:anzahlelemente
      for n=1:anzahlelemente
         if and(anzahlmat(l,m)==1,anzahlmat(l,m)==anzahlmat(l+1,n))
            uewktmat(m,n)=uewktmat(m,n)+1;
         end
      end
   end
end

reihe
uewktmat

elseif strcmp(uewktoptstatus,'j')
while  bestdist>kriterium   
    
%Reihe mit choicemat und Folgematrix erstellen und anzahl prfen bis anzahl gleichverteilt
intervall=(signallaenge/restanzahl);
while sum(idvec)<anzahlelemente
   
        %choicemat erstellen (Reihe mit Nummer des Folgeelements (choicematwert ist Spaltenindex der Folgematrix)
        choicemat=(randperm(signallaenge))'; 
        for w=1:anzahlelemente
                indices=and(choicemat>intervall*(w-1),choicemat<=intervall+intervall*(w-1));
                choicemat(indices,1)=w;
        end
         
        %anzahl der elemente in choicemat berprfen
        choicematsumvec=zeros(1,restanzahl);
        for n=1:restanzahl
            choicematsumvec(1,n)=sum(sum(choicemat==n));
        end
        
        %reihe schreiben
        reihe=zeros(1,signallaenge);
        reihe(1,1)=choicemat(1,1);
        for k=2:signallaenge
            reihe(1,k)=alternativen(reihe(1,k-1),choicemat(k,1));
        end

        %anzahl berprfen
        for n=1:anzahlelemente
            sumvec(1,n)=sum(reihe==n);
            idvec=(sumvec(1,1)==sumvec);
        end
        
        fprintf('*');
		sternzaehler=sternzaehler+1;
		if mod(sternzaehler,20)==0
            fprintf('\n');
		end
        
         if mod(sternzaehler,200)==0
            antwort=questdlg('Weitersuchen?',...
            'Optimierung:',...
            'ja','nein','ja');
                if strcmp(antwort,'nein')
                return;
            end
        end
        pause(0.0001);
     
end
idvec=0;
reihe=reihe';


%Uebergangswahrscheinlichkeiten
anzahlmat=zeros(signallaenge,anzahlelemente);
for u=1:anzahlelemente
anzahlmat(:,u)=(u==reihe(:,1));
end	
anzahlvec=sum(anzahlmat);
equalvec=(anzahlvec(1)==anzahlvec);
uewktmat=zeros(anzahlelemente);
for l=1:(signallaenge-1)
   for m=1:anzahlelemente
      for n=1:anzahlelemente
         if and(anzahlmat(l,m)==1,anzahlmat(l,m)==anzahlmat(l+1,n))
            uewktmat(m,n)=uewktmat(m,n)+1;
         end
      end
   end
end


distmat=uewktmat-erwartungsmat;
dist=sum(sum(abs(distmat)));

if dist<bestdist
    bestdist=dist
    bestreihe=reihe;
    bestuewktmat=uewktmat
end

fprintf('*');
sternzaehler=sternzaehler+1;
if sternzaehler>20
    fprintf('\n');
    sternzaehler=1;
end
end
bestreihe=reihe
bestuewktmat=uewktmat
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                   %
% mit einer Wiederholung, gleichverteilt, kein Ausschluss           %
%                                                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


elseif strcmp(wktstatus,'j') & whlstatus==1 & strcmp(whlspez,'n')
   
anzahlelemente=anzahlelemente1*anzahlelemente2;

if anzahlelemente2==1
    restanzahl=anzahlelemente1;  
else
    restanzahl=anzahlelemente1*anzahlelemente2;
end
    
%optimierungsmatritzen erstellen   
sumvec=zeros(1,anzahlelemente);
negeyemat=-eye(anzahlelemente)+ones(anzahlelemente);
idvec=zeros(1,anzahlelemente);

%koordinaten umrechnen
zaehlmat=(linspace(1,anzahlelemente1,anzahlelemente1))';
for q=2:anzahlelemente2
   zaehlmat=[zaehlmat,(linspace(1,anzahlelemente1,anzahlelemente1)+(q-1)*anzahlelemente1)'];
end

%Folgeelementmatrix bestimmen (pro Zeile alle mglichen Folgeelemente auf Zeilennummer)
%hier: alle Mglichkeiten, da Wiederholung erlaubt
    alternativenzeile=linspace(1,anzahlelemente,anzahlelemente);
    alternativen=alternativenzeile;
    for z=1:anzahlelemente
        alternativen=[alternativen;alternativenzeile];
    end
 
%signallaenge abfragen
disp(['signallaenge muss ein gemeinsames Vielfaches von ',num2str(restanzahl),' und ',num2str(anzahlelemente),' sein!']);
while 1
	signallaenge=input('signallnge?');
        if rem(signallaenge,anzahlelemente)==0   &    rem(signallaenge,restanzahl)==0
   	        break
	    else
            disp(['signallaenge muss ein gemeinsames Vielfaches von ',num2str(restanzahl),' und ',num2str(anzahlelemente),' sein!']);
        end
end


%Reihe mit choicemat und Folgematrix erstellen und anzahl prfen bis anzahl gleichverteilt
intervall=(signallaenge/restanzahl);
while sum(idvec)<anzahlelemente
   
        %choicemat erstellen (Reihe mit Nummer des Folgeelements (choicematwert ist Spaltenindex der Folgematrix)
        %hier: kontrolliert fr maximal eine Wiederholung
        choicemat=(randperm(signallaenge))'; 
        for w=1:anzahlelemente
                indices=and(choicemat>intervall*(w-1),choicemat<=intervall+intervall*(w-1));
                choicemat(indices,1)=w;
        end
        
        while 1
        breakstatus=1;
        for v=1:signallaenge-2
            if choicemat(v)==choicemat(v+1) & choicemat(v+1)==choicemat(v+2)
                buffer=choicemat(v+1);
                index=round((signallaenge-1)*rand)+1;
                choicemat(v+1)=choicemat(index);
                choicemat(index)=buffer;
                breakstatus=0;
            end
        end
        if breakstatus==1
            break
        end
        end
 
        %anzahl berprfen
        choicematsumvec=zeros(1,anzahlelemente);
        for n=1:anzahlelemente
            choicematsumvec(1,n)=sum(sum(choicemat==n));
        end

        %reihe schreiben
        reihe=zeros(1,signallaenge);
        reihe(1,1)=choicemat(1,1);
        for k=2:signallaenge
            reihe(1,k)=alternativen(reihe(1,k-1),choicemat(k,1));
        end
        pause
        %anzahl berprfen
        for n=1:anzahlelemente
            sumvec(1,n)=sum(reihe==n);
            idvec=(sumvec(1,1)==sumvec);
        end
end
reihe=reihe';


%Uebergangswahrscheinlichkeiten
anzahlmat=zeros(signallaenge,anzahlelemente);
for k=1:anzahlelemente
anzahlmat(:,k)=(k==reihe(:,1));
end	

anzahlvec=sum(anzahlmat);
equalvec=(anzahlvec(1)==anzahlvec);
uewktmat=zeros(anzahlelemente);
for l=1:(signallaenge-1)
   for m=1:anzahlelemente
      for n=1:anzahlelemente
         if and(anzahlmat(l,m)==1,anzahlmat(l,m)==anzahlmat(l+1,n))
            uewktmat(m,n)=uewktmat(m,n)+1;
         end
      end
   end
end

distmat=uewktmat


% %Ergebnisse anzeigen
% choicemat
% sumvec
% reihe
% uewktmat    
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                   %
% mit beliebiger Wiederholung (mit Aussschluss),nicht gleichverteilt%
%                                                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


elseif strcmp(wktstatus,'n') & (whlstatus==-1) & strcmp(whlspez,'j')

%Elementanzahl bestimmen  
anzahlelemente=prod(stufenvec);

%zaehlmat erstellen
cellanzahl=anzahlelemente;
zielmat=[];
stufenindices=find(stufenvec~=0);
cellhelp=[];;
for j=1:length(stufenindices),
   zielmat=[zielmat,stufenvec(j)];
end   
if isempty(zielmat)
else
  if length(zielmat)>1
            cellhelp=linspace(1,cellanzahl,cellanzahl);
            zaehlmat=reshape(cellhelp,zielmat);
  elseif length(zielmat)<2
            zaehlmat=linspace(1,cellanzahl,cellanzahl);;
  end
end
    

%optimierungsmatritzen erstellen   
sumvec=zeros(1,anzahlelemente);
negeyemat=-eye(anzahlelemente)+ones(anzahlelemente);
idvec=zeros(1,anzahlelemente);

%absolute Hufigkeiten der Zellen bestimmen
totsum=[];
for h=1:size(gradientcell,1)
    totsum(h)=sum(gradientcell{h});
end
totsumid=sum(totsum(1)==totsum);
if totsumid~=size(gradientcell,1)
    errordlg('Mismatch zwischen Signallaenge und Stimulianzahl pro Faktor!','Fehler!');
    return
end
for d=1:length(gradientcell)
stimulianzahlmat=gradientcell{d};
verhaeltniscell{d}=stimulianzahlmat./signallaenge;
end

index=[];
abshfgktmat=zeros(size(zaehlmat));
relhfgktmat=zeros(size(zaehlmat));
dimensionen=size(relhfgktmat);
indicesstring='';
for z=1:length(dimensionen)
    indicesstring=[indicesstring,'index(',num2str(z),'),'] ;  
end
indicesstring(length(indicesstring))=[];


for k=1:anzahlelemente
eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==k))',';'])
subindstring='';
for u=1:size(gradientcell,1) 
sizevar=1;
for t=1:u
    sizevar=sizevar*size(zaehlmat,t);
end
subindstring=[subindstring,num2str(verhaeltniscell{u}(index(u))),'*'];
end
subindstring(length(subindstring))=[];
eval(['abshfgktmat(',indicesstring,')=signallaenge*',subindstring,';']);
end
if int16(sum(sum(abs(abshfgktmat-round(abshfgktmat)))))>1
    errordlg('Absolute Hufigkeit mindestens einer Zelle ist dezimal! Vorgang wird abgebrochen!','Achtung:');
    return
end
abshfgktmat=round(abshfgktmat);
reihe=[];

%ausschluss
ausschlussmat;

if strcmp(uewktoptstatus,'n')

%reihe schreiben
reihe=[];
reihecell=cell(1);
restelemente=mengenminus(linspace(1,anzahlelemente,anzahlelemente),ausschlussmat);
for j=1:length(restelemente)
    eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==restelemente(j)));']);
    eval(['reihecell{restelemente(j)}=ones(1,abshfgktmat(',indicesstring,'))*restelemente(j);']);
    reihe=mergemat(reihecell{restelemente(j)},reihe,ausschlussmat);
end 

for i=1:length(ausschlussmat)
    eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==ausschlussmat(i)));']);
    eval(['reihecell{ausschlussmat(i)}=ones(1,abshfgktmat(',indicesstring,'))*ausschlussmat(i);']);
    reihe=mergemat(reihecell{ausschlussmat(i)},reihe,ausschlussmat);
end  

reihe=reihe';
idvec=0;

%Uebergangswahrscheinlichkeiten
anzahlmat=zeros(signallaenge,anzahlelemente);
for u=1:anzahlelemente
anzahlmat(:,u)=(u==reihe(:,1));
end	
anzahlvec=sum(anzahlmat);
equalvec=(anzahlvec(1)==anzahlvec);
uewktmat=zeros(anzahlelemente);
for l=1:(signallaenge-1)
   for m=1:anzahlelemente
      for n=1:anzahlelemente
         if and(anzahlmat(l,m)==1,anzahlmat(l,m)==anzahlmat(l+1,n))
            uewktmat(m,n)=uewktmat(m,n)+1;
         end
      end
   end
end

reihe
uewktmat


elseif strcmp(uewktoptstatus,'j')

%Opimieren fr Wkt

dist = 2000;
%Opimieren fr Wkt
neumat=1;
while bestdist>var(neumat(:))
	reihe=[];
	%reihe schreiben
	reihe=[];
	reihecell=cell(1);
	restelemente=mengenminus(linspace(1,anzahlelemente,anzahlelemente),ausschlussmat);
	for j=1:length(restelemente)
        eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==restelemente(j)));']);
        eval(['reihecell{restelemente(j)}=ones(1,abshfgktmat(',indicesstring,'))*restelemente(j);']);
        reihe=mergemat(reihecell{restelemente(j)},reihe,ausschlussmat);
	end 
	
	for i=1:length(ausschlussmat)
        eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==ausschlussmat(i)));']);
        eval(['reihecell{ausschlussmat(i)}=ones(1,abshfgktmat(',indicesstring,'))*ausschlussmat(i);']);
        reihe=mergemat(reihecell{ausschlussmat(i)},reihe,ausschlussmat);
	end  
	reihe=reihe';
	idvec=0;  
     
	sumvec=[];
	%anzahl berprfen
	for n=1:anzahlelemente
       sumvec(1,n)=sum(reihe==n);
	end
	
	%Uebergangswahrscheinlichkeiten
	anzahlmat=zeros(signallaenge,anzahlelemente);
	for u=1:anzahlelemente
	anzahlmat(:,u)=(u==reihe(:,1));
	end	
	anzahlvec=sum(anzahlmat);
	equalvec=(anzahlvec(1)==anzahlvec);
	uewktmat=zeros(anzahlelemente);
	for l=1:(signallaenge-1)
       for m=1:anzahlelemente
          for n=1:anzahlelemente
             if and(anzahlmat(l,m)==1,anzahlmat(l,m)==anzahlmat(l+1,n))
                uewktmat(m,n)=uewktmat(m,n)+1;
             end
          end
       end
	end
	
	if ~isempty(distmat)
        dist=sum(sum(abs(uewktmat-distmat)));
	end
	
	if uematzaehler==1
        totmat=uewktmat;
	end
	if isempty(zwischenspeicher)
        zwischenspeicher=zeros(size(uewktmat));
	end
	
	totmat=(uematzaehler*totmat+uewktmat)./(uematzaehler+1);
	uematzaehler=uematzaehler+1;
	uewktmat;
	if isempty(neumat)
        neumat=uewktmat;
	end
	neumat=(neumat+(1/avgzaehler)*uewktmat)./(1+(1/avgzaehler));
	avgzaehler=avgzaehler+1;
	%Ergebnisse anzeigen
     
	if ~isempty(distmat)
	if dist<bestdist
        bestdist=dist
        bestreihe=reihe;
        bestuewktmat=uewktmat
	end
	end
	fprintf('*');
	sternzaehler=sternzaehler+1;
	if mod(sternzaehler,20)==0
        fprintf('\n');
	end
	
	
	if sternzaehler >500
        distmat=neumat;
	end
	
	if mod(sternzaehler,600)==0
        bestdist=bestdist
        fprintf(['kriterium:',num2str(var(var(neumat))),'\n']);
        bestuewktmat=bestuewktmat
        neumat
        antwort=questdlg('Weitersuchen?',...
                'Optimierung:',...
                'ja','nein','ja');
        if strcmp(antwort,'nein')
            break
        end
	end
	
	if mod(sternzaehler,200)==0
	end
end

bestreihe 
bestuewktmat
bestdist
fprintf(['kriterium:',num2str(var(bestuewktmat(:)))]);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                   %
%mit beliebiger Wiederholung (kein Aussschluss),nicht gleichverteilt%
%                                                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



elseif strcmp(wktstatus,'n') & (whlstatus==-1) & strcmp(whlspez,'n')
 
%Elementanzahl bestimmen  
anzahlelemente=prod(stufenvec);

%optimierungsmatritzen erstellen   
sumvec=zeros(1,anzahlelemente);
negeyemat=-eye(anzahlelemente)+ones(anzahlelemente);
idvec=zeros(1,anzahlelemente);

%zaehlmat erstellen
cellanzahl=anzahlelemente;
zielmat=[];
stufenindices=find(stufenvec~=0);
cellhelp=[];;
for j=1:length(stufenindices),
   zielmat=[zielmat,stufenvec(j)];
end   
if isempty(zielmat)
else
  if length(zielmat)>1
            cellhelp=linspace(1,cellanzahl,cellanzahl);
            zaehlmat=reshape(cellhelp,zielmat);
  elseif length(zielmat)<2
            zaehlmat=linspace(1,cellanzahl,cellanzahl);;
  end
end

%optimierungsmatritzen erstellen   
sumvec=zeros(1,anzahlelemente);
negeyemat=-eye(anzahlelemente)+ones(anzahlelemente);
idvec=zeros(1,anzahlelemente);


%absolute Hufigkeiten der Zellen bestimmen
totsum=[];
for h=1:size(gradientcell,1)
    totsum(h)=sum(gradientcell{h});
end
totsumid=sum(totsum(1)==totsum);
if totsumid~=size(gradientcell,1)
    errordlg('Mismatch zwischen Signallaenge und Stimulianzahl pro Faktor!','Fehler!');
    return
end
for d=1:length(gradientcell)
stimulianzahlmat=gradientcell{d};
verhaeltniscell{d}=stimulianzahlmat./signallaenge;
end

index=[];
abshfgktmat=zeros(size(zaehlmat));
relhfgktmat=zeros(size(zaehlmat));
dimensionen=size(relhfgktmat);
indicesstring='';
for z=1:length(dimensionen)
    indicesstring=[indicesstring,'index(',num2str(z),'),'] ;  
end
indicesstring(length(indicesstring))=[];


for k=1:anzahlelemente
eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==k))',';'])
subindstring='';
for u=1:size(gradientcell,1) 
sizevar=1;
for t=1:u
    sizevar=sizevar*size(zaehlmat,t);
end
subindstring=[subindstring,num2str(verhaeltniscell{u}(index(u))),'*'];
end
subindstring(length(subindstring))=[];
eval(['abshfgktmat(',indicesstring,')=signallaenge*',subindstring,';']);
end
if sum(abs(abshfgktmat-round(abshfgktmat)))>2
    errordlg('Absolute Hufigkeit mindestens einer Zelle ist dezimal! Vorgang wird abgebrochen!','Achtung:');
    return
end
abshfgktmat=round(abshfgktmat);
reihe=[];

if strcmp(uewktoptstatus,'n')   
    
reihe=[];
%reihe schreiben
reihecell=cell(1);
for i=1:anzahlelemente
    eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==i));']);
    eval(['reihecell{i}=ones(1,abshfgktmat(',indicesstring,'))*i;']);
    reihe=mergemat(reihe,reihecell{i});
end  
reihe=reihe';
idvec=0;

%Uebergangswahrscheinlichkeiten
anzahlmat=zeros(signallaenge,anzahlelemente);
for u=1:anzahlelemente
anzahlmat(:,u)=(u==reihe(:,1));
end	
anzahlvec=sum(anzahlmat);
equalvec=(anzahlvec(1)==anzahlvec);
uewktmat=zeros(anzahlelemente);
for l=1:(signallaenge-1)
   for m=1:anzahlelemente
      for n=1:anzahlelemente
         if and(anzahlmat(l,m)==1,anzahlmat(l,m)==anzahlmat(l+1,n))
            uewktmat(m,n)=uewktmat(m,n)+1;
         end
      end
   end
end


reihe
uewktmat


elseif strcmp(uewktoptstatus,'j')  
dist = 2000;
%Opimieren fr Wkt
while bestdist>var(var(neumat))
reihe=[];
%reihe schreiben
reihecell=cell(1);
for i=1:anzahlelemente
    eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==i));']);
    eval(['reihecell{i}=ones(1,abshfgktmat(',indicesstring,'))*i;']);
    reihe=mergemat(reihe,reihecell{i});
end    
 
sumvec=[];
%anzahl berprfen
for n=1:anzahlelemente
   sumvec(1,n)=sum(reihe==n);
end
reihe=reihe';
idvec=0;

%Uebergangswahrscheinlichkeiten
anzahlmat=zeros(signallaenge,anzahlelemente);
for u=1:anzahlelemente
anzahlmat(:,u)=(u==reihe(:,1));
end	
anzahlvec=sum(anzahlmat);
equalvec=(anzahlvec(1)==anzahlvec);
uewktmat=zeros(anzahlelemente);
for l=1:(signallaenge-1)
   for m=1:anzahlelemente
      for n=1:anzahlelemente
         if and(anzahlmat(l,m)==1,anzahlmat(l,m)==anzahlmat(l+1,n))
            uewktmat(m,n)=uewktmat(m,n)+1;
         end
      end
   end
end

if ~isempty(distmat)
    dist=sum(sum(abs(uewktmat-distmat)));
end

if uematzaehler==1
    totmat=uewktmat;
end
if isempty(zwischenspeicher)
    zwischenspeicher=zeros(size(uewktmat));
end

totmat=(uematzaehler*totmat+uewktmat)./(uematzaehler+1);
uematzaehler=uematzaehler+1;
uewktmat;
if isempty(neumat)
    neumat=uewktmat;
end
neumat=(neumat+(1/avgzaehler)*uewktmat)./(1+(1/avgzaehler));
avgzaehler=avgzaehler+1;




% %Ergebnisse anzeigen
% choicemat
 
if ~isempty(distmat)
if dist<bestdist
    bestdist=dist
    bestreihe=reihe;
    bestuewktmat=uewktmat
end
end
fprintf('*');
sternzaehler=sternzaehler+1;
if mod(sternzaehler,20)==0
    fprintf('\n');
end


if sternzaehler >500
    distmat=neumat;
end

if mod(sternzaehler,600)==0
    bestdist=bestdist
    fprintf(['kriterium:',num2str(var(var(neumat))),'\n']);
    bestuewktmat=bestuewktmat
    neumat
    antwort=questdlg('Weitersuchen?',...
            'Optimierung:',...
            'ja','nein','ja');
    if strcmp(antwort,'nein')
        
        break
    end
end

if mod(sternzaehler,200)==0
end
end

bestreihe 
bestuewktmat
bestdist
fprintf(['kriterium:',num2str(var(var(bestuewktmat)))]);
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                   %
% mit beliebiger Wiederholung (kein Aussschluss), gleichverteilt    %
%                                                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


elseif strcmp(wktstatus,'j') & (whlstatus==-1) & strcmp(whlspez,'n')
 
%Elementanzahl bestimmen  
anzahlelemente=prod(stufenvec);

%optimierungsmatritzen erstellen   
sumvec=zeros(1,anzahlelemente);
negeyemat=-eye(anzahlelemente)+ones(anzahlelemente);
idvec=zeros(1,anzahlelemente);

%erwartungsmat
erwartungswert=signallaenge/(anzahlelemente*anzahlelemente);
erwartungsmat=ones(anzahlelemente)*erwartungswert;

%zaehlmat erstellen
cellanzahl=anzahlelemente;
zielmat=[];
stufenindices=find(stufenvec~=0);
cellhelp=[];;
for j=1:length(stufenindices),
   zielmat=[zielmat,stufenvec(j)];
end   
if isempty(zielmat)
else
  if length(zielmat)>1
            cellhelp=linspace(1,cellanzahl,cellanzahl);
            zaehlmat=reshape(cellhelp,zielmat);
  elseif length(zielmat)<2
            zaehlmat=linspace(1,cellanzahl,cellanzahl);;
  end
end

%optimierungsmatritzen erstellen   
sumvec=zeros(1,anzahlelemente);
negeyemat=-eye(anzahlelemente)+ones(anzahlelemente);
idvec=zeros(1,anzahlelemente);


%absolute Hufigkeiten der Zellen bestimmen
totsum=[];
for h=1:size(gradientcell,1)
    totsum(h)=sum(gradientcell{h});
end
totsumid=sum(totsum(1)==totsum);
if totsumid~=size(gradientcell,1)
    errordlg('Mismatch zwischen Signallaenge und Stimulianzahl pro Faktor!','Fehler!');
    return
end
for d=1:length(gradientcell)
stimulianzahlmat=gradientcell{d};
verhaeltniscell{d}=stimulianzahlmat./signallaenge;
end

abshfgktmat=zeros(size(zaehlmat));
relhfgktmat=zeros(size(zaehlmat));
dimensionen=size(relhfgktmat);
indicesstring='';
for z=1:length(dimensionen)
    indicesstring=[indicesstring,'i',num2str(z),','] ;  
end
indicesstring(length(indicesstring))=[];

for k=1:anzahlelemente
eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==k))',';'])
subindstring='';
for u=1:size(gradientcell,1) 
sizevar=1;
for t=u+1:length(size(zaehlmat))
    sizevar=sizevar*size(zaehlmat,t);
end
subindstring=[subindstring,num2str(verhaeltniscell{u}(mod(anzahlelemente,sizevar+1))),'*'];
end
subindstring(length(subindstring))=[];
eval(['abshfgktmat(',indicesstring,')=signallaenge*',subindstring,';']);

end
abshfgktmat=round(abshfgktmat);
reihe=[];
if strcmp(uewktoptstatus,'n')

%reihe schreiben
reihe=[];
reihecell=cell(1);
for i=1:anzahlelemente
    eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==k));']);
    eval(['reihecell{i}=ones(1,abshfgktmat(',indicesstring,'))*i;']);
    reihe=mergemat(reihe,reihecell{i});
end
reihe=reihe';

%Uebergangswahrscheinlichkeiten
anzahlmat=zeros(signallaenge,anzahlelemente);
for u=1:anzahlelemente
anzahlmat(:,u)=(u==reihe(:,1));
end	
anzahlvec=sum(anzahlmat);
equalvec=(anzahlvec(1)==anzahlvec);
uewktmat=zeros(anzahlelemente);
for l=1:(signallaenge-1)
   for m=1:anzahlelemente
      for n=1:anzahlelemente
         if and(anzahlmat(l,m)==1,anzahlmat(l,m)==anzahlmat(l+1,n))
            uewktmat(m,n)=uewktmat(m,n)+1;
         end
      end
   end
end
reihe
uewktmat

elseif strcmp(uewktoptstatus,'j')

%Opimieren fr Wkt
while bestdist>kriterium
reihe=[];
%reihe schreiben
reihecell=cell(1);
for i=1:anzahlelemente
    eval(['[',indicesstring,']=ind2sub(size(zaehlmat),find(zaehlmat==k));']);
    eval(['reihecell{i}=ones(1,abshfgktmat(',indicesstring,'))*i;']);
    reihe=mergemat(reihe,reihecell{i});
end    
 
sumvec=[];
%anzahl berprfen
for n=1:anzahlelemente
   sumvec(1,n)=sum(reihe==n);
end

reihe=reihe';
idvec=0;

%Uebergangswahrscheinlichkeiten
anzahlmat=zeros(signallaenge,anzahlelemente);
for u=1:anzahlelemente
anzahlmat(:,u)=(u==reihe(:,1));
end	
anzahlvec=sum(anzahlmat);
equalvec=(anzahlvec(1)==anzahlvec);
uewktmat=zeros(anzahlelemente);
for l=1:(signallaenge-1)
   for m=1:anzahlelemente
      for n=1:anzahlelemente
         if and(anzahlmat(l,m)==1,anzahlmat(l,m)==anzahlmat(l+1,n))
            uewktmat(m,n)=uewktmat(m,n)+1;
         end
      end
   end
end

dist=sum(sum(abs(uewktmat-erwartungsmat)));

%mittlere erwartungsmat
if uematzaehler==1
    totmat=uewktmat;
end
if isempty(zwischenspeicher)
    zwischenspeicher=zeros(size(uewktmat));
end

totmat=(uematzaehler*totmat+uewktmat)./(uematzaehler+1);
uematzaehler=uematzaehler+1;
uewktmat;
if isempty(neumat)
    neumat=uewktmat;
end
neumat=(neumat+(1/avgzaehler)*uewktmat)./(1+(1/avgzaehler));
avgzaehler=avgzaehler+1;

% %Ergebnisse anzeigen

if dist<bestdist
    bestdist=dist
    bestreihe=reihe;
    bestuewktmat=uewktmat
end

fprintf('*');
sternzaehler=sternzaehler+1;
if mod(sternzaehler,20)==0
    fprintf('\n');
end

if mod(sternzaehler,200)==0
   antwort=questdlg('Weitersuchen?',...
        'Optimierung:',...
        'ja','nein','ja');
   if strcmp(antwort,'nein')
       bestreihe
       bestuewktmat 
       return;
   end
end
end

                   
bestreihe
bestuewktmat
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                   %
% ohne Wiederholung, nicht gleichverteilt                           %
%                                                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

elseif strcmp(wktstatus,'n') & (strcmp(whlstatus,'n')|strcmp(whlstatus,'0')) & strcmp(whlspez,'j')

 
    
anzahlelemente=anzahlelemente1*anzahlelemente2;
if anzahlelemente1==1
    restanzahl=(anzahlelemente2-1);
elseif anzahlelemente2==1
    restanzahl=(anzahlelemente1-1);  
else
    restanzahl=(anzahlelemente1-1)*(anzahlelemente2-1);
end



%Rel. Hufigkeiten erfragen
wktmat=zeros(1,anzahlelemente2);
while 1
for g=1:anzahlelemente2
wkt=input(['Rel. Hufigkeit von Element ', num2str(g), ' aus 2.Dimension?']);
wktmat(1,g)=wkt;
end
if abs(sum(wktmat)-1)<0.05
    break
else
    disp('Rel. Hufigkeiten mssen in der Summe 1 ergeben!')
end
end
wkttotmat=wktmat;
for f=1:anzahlelemente1
    wkttotmat=[wkttotmat;wktmat];
end


pause

%koordinaten umrechnen
zaehlmat=(linspace(1,anzahlelemente1,anzahlelemente1))';
for q=2:anzahlelemente2
   zaehlmat=[zaehlmat,(linspace(1,anzahlelemente1,anzahlelemente1)+(q-1)*anzahlelemente1)'];
end


%Ausschluss erfragen
fprintf('\n');
disp('Folgende Elemente und Wahrscheinlichkeiten haben sie gewhlt:');
fprintf('\n');
disp('Elemente:');
fprintf('\n');
disp(zaehlmat);
fprintf('\n');
disp('Wahrscheinlichkeiten:');
fprintf('\n');
disp(wkttotmat);
fprintf('\n');
ausschlussmat=[];
 r=1;
while 1 
ausschlussmat(r)=input('Welche Elemente duerfen sich nicht wiederholen? (0=abbruch)');
if ausschlussmat(r)==0
    break
end
r=r+1;
end
ausschlussmat(find(ausschlussmat==0))=[];
fprintf('\n');
disp(ausschlussmat);
fprintf('duerfen sich nicht wiederholen!\n\n');

%optimierungsmatritzen erstellen   
sumvec=zeros(1,anzahlelemente);
negeyemat=-eye(anzahlelemente)+ones(anzahlelemente);
idvec=zeros(1,anzahlelemente);

%Folgeelementmatrix bestimmen (pro Zeile alle mglichen Folgeelemente auf Zeilennummer)
    alternativen=zeros(anzahlelemente,restanzahl);
    for dings=1:anzahlelemente
        altindices=(find(zaehlmat>0))';
        gleichespalte=find(and(altindices>anzahlelemente1*floor(zaehlmat(dings)/(anzahlelemente1+0.00001)),altindices<=anzahlelemente1+anzahlelemente1*floor(zaehlmat(dings)/(anzahlelemente1+0.00001))));  
        gleichezeile=find(rem(altindices,anzahlelemente1)==rem(zaehlmat(dings),anzahlelemente1));
        anzahlspaltindices=size(gleichespalte);
        anzahlzeilindices=size(gleichezeile);
        equalindices=zeros(anzahlspaltindices(2),anzahlzeilindices(2));
      pause
        for t=1:anzahlspaltindices(2)
             equalindices(t,:)=(gleichespalte(t)==gleichezeile);
        end
        [equalspaltindices,equalzeilindices]=find(equalindices==1);
        gleichespalte(equalspaltindices)=[];
        if and(anzahlelemente1~=1,anzahlelemente2~=1)
            altindices([gleichespalte gleichezeile])=[];
        elseif anzahlelemente1==1
            altindices(gleichespalte)=[];
        elseif anzahlelemente2==1
            altindices(gleichezeile)=[];
        end
        for bums=1:restanzahl
      	    alternativen(dings,bums)=zaehlmat(altindices(bums));
        end
        alternativen(dings,:)=alternativen(dings,:);
    end


%signallaenge abfragen
disp(['signallaenge muss ein gemeinsames Vielfaches von ',num2str(restanzahl),' und ',num2str(anzahlelemente),' sein!']);
while 1
	signallaenge=input('signallnge?');
        if rem(signallaenge,anzahlelemente)==0   &    rem(signallaenge,restanzahl)==0
   	        break
	    else
            disp(['signallaenge muss ein gemeinsames Vielfaches von ',num2str(restanzahl),' und ',num2str(anzahlelemente),' sein!']);
        end
end


%Reihe mit choicemat und Folgematrix erstellen und anzahl prfen bis anzahl gleichverteilt
intervall=(signallaenge/restanzahl);
while sum(idvec)<anzahlelemente
   
        %choicemat erstellen (Reihe mit Nummer des Folgeelements (choicematwert ist Spaltenindex der Folgematrix)
        choicemat=(randperm(signallaenge))'; 
        for w=1:anzahlelemente
                indices=and(choicemat>intervall*(w-1),choicemat<=intervall+intervall*(w-1));
                choicemat(indices,1)=w;
        end
         
        %anzahl berprfen
        choicematsumvec=zeros(1,anzahlelemente-1);
        for n=1:anzahlelemente-1
            choicematsumvec(1,n)=sum(sum(choicemat==n));
        end

        %reihe schreiben
        reihe=zeros(1,signallaenge);
        reihe(1,1)=choicemat(1,1);
        for k=2:signallaenge
            reihe(1,k)=alternativen(reihe(1,k-1),choicemat(k,1));
            
        end

        %anzahl berprfen
        for n=1:anzahlelemente
            sumvec(1,n)=sum(reihe==n);
            idvec=(sumvec(1,1)==sumvec);
        end
      
end
reihe=reihe';
pause

%Uebergangswahrscheinlichkeiten
anzahlmat=zeros(signallaenge,anzahlelemente);
for u=1:anzahlelemente
anzahlmat(:,u)=(u==reihe(:,1));
end	
anzahlvec=sum(anzahlmat);
equalvec=(anzahlvec(1)==anzahlvec);
uewktmat=zeros(anzahlelemente);
for l=1:(signallaenge-1)
   for m=1:anzahlelemente
      for n=1:anzahlelemente
         if and(anzahlmat(l,m)==1,anzahlmat(l,m)==anzahlmat(l+1,n))
            uewktmat(m,n)=uewktmat(m,n)+1;
         end
      end
   end
end

% %Ergebnisse anzeigen
% choicemat
% sumvec
% reihe
% uewktmat


else 
    errorcell=cell(1);
    errorcell{1}='Fr die Option: ';
    errorcell{2}='';
    errorcell{3}=['  Faktoren: ',num2str(anzahlfaktoren)];
    errorcell{4}=['  gleichverteilte Wkt = ',wktstatus];
    if whlstatus == 0
        errorcell{5}=['  Wiederholungen zulassen: n'];
    else 
        errorcell{5}=['  Wiederholungen zulassen: ',num2str(whlstatus)];
    end
    if isempty(ausschlussmat)
        errorcell{6}='  Ausschluss: n';
    else
        errorcell{6}=['  Ausschluss: ',whlspez,' :',num2str(ausschlussmat)];
    end
    errorcell{7}=['  bgwkten: ',uewktoptstatus];
    errorcell{8}='';
    errorcell{9}='existiert noch kein Skript!';
    errordlg(errorcell,'Sorry!');
    return
end



%wegschreiben
fileradio = findobj('Tag','fileradio');
if  get(fileradio,'Value')==1
    [savefilename,savefilepath]=uiputfile('*.txt','Zieldatei benennen:');
    savefile=[savefilepath,savefilename];
    fid = fopen(savefile,'wt');
    fprintf(fid,'Randomizer:\n\n');
    fprintf(fid,['Reihe mit ',num2str(signallaenge),' Elementen bestehend aus ',num2str(anzahlelemente),' verschiedenen Zahlen:\n']);  
    if whlstatus==0
       fprintf(fid,'(keine Wiederholungen');
    else
        if widmat==-1
            fprintf(fid,['(mit beliebiger Wiederholung']);
        else
            fprintf(fid,['(',num2str(widmat),' zugelassene Wiederholungen']);
        end
    end
    if strcmp(whlspez,'j')
        fprintf(fid,[', mit Ausschluss der Wiederholung der Elemente ',num2str(ausschlussmat),' )\n']);
    else 
       fprintf(fid,')\n'); 
    end
    fprintf(fid,['array <int> reihe [',num2str(signallaenge),']={']);
    if strcmp(uewktoptstatus,'j')
        fprintf(fid,'%i',bestreihe(1));
        for j=2:length(bestreihe)
            fprintf(fid,',');
            fprintf(fid,'%i',bestreihe(j));
        end   
    else
        fprintf(fid,'%i',reihe(1));
        for j=2:length(reihe)
            fprintf(fid,',');
            fprintf(fid,'%i',reihe(j));
        end  
    end
    fprintf(fid,'};\n\n');
    if strcmp(uewktoptstatus,'j')
        fprintf(fid,'bergangswahrscheinlichkeiten:\n\n');
            for l=1:size(uewktmat,1)
                for k=1:size(uewktmat,2)
                    fprintf(fid,[num2str(uewktmat(l,k)),'\t']);
                end
                fprintf(fid,'\n');
            end
    end   
    fclose(fid);
    
    answer = questdlg('Do you wish to view the output-file now?','File:','Yes','No','Yes');
    if strcmp(answer,'Yes')
        edit savefile;
    end
end


    
    








