function readcrossmodalratingsmanage(filename,filepath,mode)

%   readcrossmodalratingsmanage

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if mode==0
   modefehler
   return

% directory mode   
elseif mode==11
   cd (filepath);
   filelist=dir(filepath);
   filelistsize=size(filelist);
   stimname = cell(180,filelistsize-2);
   valence = zeros(180,filelistsize-2);
   arousal = zeros(180,filelistsize-2);
   valtime = zeros(180,filelistsize-2);
   arotime = zeros(180,filelistsize-2); 
   tottime = zeros(180,filelistsize-2); 
	% Schleife fr Files
   for filezaehler=3:filelistsize(1)
        [stimnametmp,valencetmp,arousaltmp,valtimetmp,arotimetmp,tottimetmp] = readcrossmodalratings(filelist(filezaehler).name);
   end
   ok
   
% batchfile mode   
elseif mode==12
    
   filemat=batchfiletomat(filename,filepath);
   filematgroessevec=size(filemat);
   filematgroesse=filematgroessevec(2);
   stimname = cell(180,filematgroesse);
   valence = zeros(180,filematgroesse);
   arousal = zeros(180,filematgroesse);
   valtime = zeros(180,filematgroesse);
   arotime = zeros(180,filematgroesse); 
   tottime = zeros(180,filematgroesse); 
   
   for l=1:filematgroesse
        [stimnametmp,valencetmp,arousaltmp,valtimetmp,arotimetmp,tottimetmp] = readcrossmodalratings(filemat{l});
        [stimnametmp,order] = sort(stimnametmp);
        valencetmp = valencetmp(order);
        arousaltmp = arousaltmp(order);
        valtimetmp = valtimetmp(order);
        arotimetmp = arotimetmp(order); 
        tottimetmp = tottimetmp(order); 
        for i=1:180
            stimname{i,l} = stimnametmp{i};
        end
        valence(:,l) = valencetmp;
        arousal(:,l) = arousaltmp;
        valtime(:,l) = valtimetmp;
        arotime(:,l) = arotimetmp; 
        tottime(:,l) = tottimetmp; 
   end
     
   avgvalence = zeros(180,1);
   avgvalence = mean(valence,2);
   avgarousal = mean(arousal,2);
   avgvaltime = mean(valtime,2);
   avgarotime = mean(arotime,2);
   avgtottime = mean(tottime,2);
   
   initpath = SetDefPath(1);
   [avgfilename,avgfilepath] = uiputfile([initpath,'*.txt'],'Please choose avg filename:');
   avgfile = [avgfilepath,avgfilename];
   SetDefPath(2,avgfilepath);
   fid = fopen(avgfile,'wt');
   
   fprintf(fid,'Stimulus\tValence\tArousal\tValtime\tArotime\tTottime\n');
   for lineind = 1:180
       fprintf(fid,[stimnametmp{lineind},'\t']);
       fprintf(fid,[num2str(avgvalence(lineind)),'\t']);
       fprintf(fid,[num2str(avgarousal(lineind)),'\t']);
       fprintf(fid,[num2str(avgvaltime(lineind)),'\t']);
       fprintf(fid,[num2str(avgarotime(lineind)),'\t']);
       fprintf(fid,[num2str(avgtottime(lineind)),'\n']);
   end
   fclose(fid);
   edit(avgfile);
   ok
      
% single file mode   
elseif mode==2
   stimname = cell(180,1);
   valence = zeros(180,1);
   arousal = zeros(180,1);
   valtime = zeros(180,1);
   arotime = zeros(180,1); 
   tottime = zeros(180,1); 
   [stimname,valence,arousal,valtime,arotime,tottime] = readcrossmodalratings(filename);
   ok  
end
return