function readpairstoanovamanage(filename,filepath,mode,farbrand)

%   readpairstoanovamanage

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

farbrand = [1 2 3 4 5 6 1 2 3 4 5 6 1 2 3 4 5 6 1 2 3 4 5 6];
if isempty(farbrand)
	prompt={'Please enter farbrand parameter(s):'};
	def={'1'};
	dlgTitle='farbrand';
	lineNo=1;
	answer=inputdlg(prompt,dlgTitle,lineNo,def);
	farbrand = str2num(answer{1});
end
       
if mode==0
   modefehler
   return

% directory mode   
elseif mode==11
    
  	cd (filepath);
    filelist=dir(filepath);
    filelistsize=size(filelist);
    sumscores=cell(1);
    vpnummer=cell(1);
	% Schleife fr Files
   for filezaehler=3:filelistsize(1)
      [vpnummer{filezaehler-2},sumscores{filezaehler-2}]=readpairstoanova([],filelist(filezaehler).name,filepath,farbrand(filezaehler-2));
   end
   
   %ergebnisfile schreiben
   %-----------------------
   [savefilename,savefilepath]=uiputfile(filepath,'Bitte benennen Sie das Ergebnisfile:');
   if isempty(findstr(savefilename,'.txt'))
       savefilename=[savefilename,'.txt'];
   end
   savefile=[savefilepath,savefilename];
   fid= fopen(savefile,'wt');
   %header
   fprintf(fid,['VP\tsound1\tsound2\tsound3\tsound4\tsound5\tsound6\t\n']);
   fprintf(fid,['----------------------------------------------------------\n']);
   for z=1:length(vpnummer)
       fprintf(fid,[num2str(vpnummer(z)),'\t']);
       %data
       for r=1:6
           fprintf(fid,[num2str(sumscores{z}(r)),'\t']);
       end
       fprintf(fid,'\n');
   end
   fclose (fid);
   ok
   
% batchfile mode   
elseif mode==12
   filemat=batchfiletomat(filename,filepath);
   filematgroessevec=size(filemat);
   filematgroesse=filematgroessevec(2);
    sumscores=cell(1);
    vpnummer=cell(1);
   for l=1:filematgroesse
      [vpnummer{l},sumscores{l}]=readpairstoanova([],filemat{l},[],farbrand(l));
   end
   [savefilename,savefilepath]=uiputfile([filepath,filename],'Bitte benennen Sie das Ergebnisfile:');
   if isempty(findstr(savefilename,'.txt'))
       savefilename=[savefilename,'.txt'];
   end
   savefile=[savefilepath,savefilename];
   
   fid= fopen(savefile,'wt');
   %header
   fprintf(fid,['VP\tsound1\tsound2\tsound3\tsound4\tsound5\tsound6\t\n']);
   fprintf(fid,['----------------------------------------------------------\n']);
   for z=1:length(vpnummer)
       fprintf(fid,[num2str(vpnummer{z}),'\t']);
       %data
       for r=1:6
           fprintf(fid,[num2str(sumscores{z}(r)),'\t']);
       end
       fprintf(fid,'\n');
   end
   fclose (fid);
   ok
      
% single file mode   
elseif mode==2
    sumscores=cell(1);
    vpnummer=cell(1);
   [vpnummer{1},sumscores{1}]=readpairstoanova([],filename,filepath,farbrand(1));
   [savefilename,savefilepath]=uiputfile('*.txt','Bitte benennen Sie das Ergebnisfile:');
   if isempty(findstr(savefilename,'.txt'))
       savefilename=[savefilename,'.txt'];
   end
   savefile=[savefilepath,savefilename];
   fid= fopen(savefile,'wt');
   %header
   fprintf(fid,['VP\tsound1\tsound2\tsound3\tsound4\tsound5\tsound6\t\n']);
   fprintf(fid,['----------------------------------------------------------\n']);
   for z=1
       fprintf(fid,[num2str(vpnummer{1}),'\t']);
       %data
       for r=1:6
           fprintf(fid,[num2str(sumscores{z}(r)),'\t']);
       end
       fprintf(fid,'\n');
   end
   fclose (fid);
   ok
   
   
end

edit(savefile);

return