function [dim,anzahldims,anzahlstimuli,paramat,filenamecell]=readparamat(filename,filepath,paramat,filenamecell)

%   readparamat

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


paramat=[];
dim=cell(1,1);
filenamecell=cell(1);
file=[filepath filename];
fid=fopen(file,'rt');

dbstop if error


%dims einlesen (header)
%-----------------
dimstring=fgetl(fid);
delimiters=findstr(char(9),dimstring);
if isempty(delimiters)
    uiwait(errordlg('Das Datenfile muss ein tab-getrenntes text-file sein! Der Header enthielt keine Tab-stopps!','Achtung:'));
    return
end
if ~isempty(findstr(dimstring,'-'))
    uiwait(errordlg('Die Headerzeile des Datenfiles darf keine Bindestriche enthalten, da diese bei der Definition der Requirements eingesetzt werden!'));
    return
end
dim{1}=dimstring(1:delimiters(1)-1);
for j=1:length(delimiters)-1
    dim{j+1}=dimstring(delimiters(j)+1:delimiters(j+1)-1);
    if ~isempty(findstr(dim{j+1},' '))
        dim{j+1}(findstr(dim{j+1},' '))=[];
    end
    if ~isempty(findstr(dim{j+1},'_'))
        dim{j+1}(findstr(dim{j+1},'_'))=[];
    end
end
dim{length(delimiters)+1}=dimstring(delimiters(length(delimiters))+1:end);
if ~isempty(findstr(dim{length(delimiters)+1},' '))
   dim{length(delimiters)+1}(findstr(dim{length(delimiters)+1},' '))=[];
end
    
dim{length(delimiters)+2}='anzahl';
anzahldims=length(delimiters)+1;


%data einlesen
%---------------
j=1;
leerezellenstatus=0;
leerezeilenstatus=0;
linestring=fgetl(fid);
warning off
while linestring ~= -1
    if length(findstr(char(9),linestring))-length(linestring)<-2
        delimiters=[0,findstr(linestring,char(9)),length(linestring)+1];
        filenamecell{j}=linestring(delimiters(1)+1:delimiters(2)-1);
        for i=2:length(delimiters)-1
            if length(str2num(linestring(delimiters(i)+1:delimiters(i+1)-1))) > 1
                uiwait(errordlg('Text can only contain numbers with a ''.'' as decimal separator!','Error:'));
                dim=[];
                anzahldims=[];
                anzahlstimuli=[];
                paramat=[];
                filenamecell=[];
                
                return
            elseif ~isempty(str2num(linestring(delimiters(i)+1:delimiters(i+1)-1)))
                 paramat(j,i-1)=str2num(linestring(delimiters(i)+1:delimiters(i+1)-1));
            else 
                 paramat(j,i-1)=0;
                 leerezellenstatus = 1;
            end
        end 
    else
        j=j-1;
        leerezeilenstatus=1;
    end
linestring=fgetl(fid);
j=j+1;
end  
warning on
anzahlstimuli=j-1;
if leerezeilenstatus == 1
    uiwait(errordlg('Es befanden sich leer Zeilen im Datenfile! Diese wurden ignoriert.','Achtung:'));
end
if leerezellenstatus == 1
    uiwait(errordlg('Es befanden sich leere Zellen in der Datenmatrix! Diese wurden mit Null ersetzt!','Achtung:'));
end



fclose(fid);
dbclear if error


return