function readwebwordratings(sourcefilepath,sourcefilename,filepath,filename)

%   readwebwordratings

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin < 4
    file = filepath;
else
    file=[filepath,filename];
end

%vars initialisieren
ratingscell=cell(1);
numberofpics=109;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%mail einlesen
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


fid=fopen(file,'rt');



%Datum
datumstring=fgetl(fid);
if ~isempty(findstr('From:',datumstring))
    datumstring = fgetl(fid),
end
datum=datumstring(7:length(datumstring));
whitespace=findstr(datum,' ');
datum(whitespace)='_';


discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);
discard=fgetl(fid);

%ID
IDstring = fgetl(fid);

ID=IDstring(5:size(IDstring,2));
correct=length(ID);
[idfilename,idfilepath]=uigetfile('*.txt','IDfile auswhlen (cancel berspringt ID-Check):');
if ~isequal(idfilename,0) & ~isequal (idfilepath,0)
    
IDfile=[idfilepath idfilename];
IDfile=fopen(IDfile,'rt');

validIDmat=fscanf(IDfile,'%i');
fclose(IDfile);

if correct>9 | correct<8 | isempty(find(str2num(ID)==validIDmat))
    ButtonName=questdlg('Ungltige ID! Quit?', ...
                       'Achtung:', ...
                       'ja','nein','nein');
    switch ButtonName,
    case 'ja', 
        fclose all;
        return
    case 'nein',
    end
end

end


discard=fgetl(fid);




%geschlecht in geschlechtvar
geschlecht = fgetl(fid);
geschlecht_start=findstr(geschlecht,':');
geschlechtvar=geschlecht(geschlecht_start+2);

discard=fgetl(fid);

%haendigkeit
haendigkeit = fgetl(fid);
haendigkeit_start=findstr(haendigkeit,':');
haendigkeitvar=haendigkeit(haendigkeit_start+2);

discard=fgetl(fid);

%schulabschluss & alter
schulabschluss = fgetl(fid);
if ~isempty(findstr('A',schulabschluss)) | ~isempty(findstr('HS',schulabschluss)) | ~isempty(findstr('MR',schulabschluss))
    schulabschluss_start=findstr(schulabschluss,':');
    schulabschlussvar=schulabschluss(schulabschluss_start+2:end);

    discard=fgetl(fid);
    %alter in altervar schreiben
	alter=fgetl(fid);
	alter_start=findstr(alter,':');
	altervar=alter(alter_start+2:alter_start+3);
	discard=fgetl(fid);
else
    schulabschlussvar = '-';
    %alter in altervar schreiben
    alter=schulabschluss;
	alter_start=findstr(alter,':');
	altervar=alter(alter_start+2:alter_start+3);
	discard=fgetl(fid);
end

%bdi
bdi = fgetl(fid);
bdi_start=findstr(bdi,':');
bdivar=geschlecht(bdi_start:end);

discard=fgetl(fid);

%state
state = fgetl(fid);
state_start=findstr(state,':');
statevar=state(state_start+2:end);

discard=fgetl(fid);

%trait
trait = fgetl(fid);
trait_start=findstr(trait,':');
traitvar=trait(trait_start+2:end);

discard=fgetl(fid);


%verlauf in totalcall schreiben
verlaufsmatneu=fscanf(fid,'%s');
verlaufsmatneu(findstr(verlaufsmatneu,'-'))=[];
verlaufsmatneu(end+1)=',';

verlaufscell=cell(1);
kommata=findstr(verlaufsmatneu,',');
picindices=findstr(verlaufsmatneu,'stim');
nrofratedpics=0;  
for z=1:length(picindices)-1
    verlaufscell{z}=verlaufsmatneu(picindices(z):picindices(z+1)-1);
end

cellkommata=cell(1);
%anzahl der registrierten Stimuli feststellen (nrofratedpics)
verlaufscell{length(picindices)}=verlaufsmatneu(picindices(length(picindices)):length(verlaufsmatneu));
for v=1:length(verlaufscell)
    cellkommata{v}=findstr(verlaufscell{v},',');
    if length(cellkommata{v})>130
        break
    end
    nrofratedpics=nrofratedpics+1;
end

%totkommota um "verlaufsmat" einrcken
totkommata=findstr(verlaufsmatneu,',');
totkommata2=totkommata;
totkommata2(1,1)=15;
for r=1:length(totkommata)-1
    totkommata2(r+1)=totkommata(r);
end
totkommata2(length(totkommata)+1)=totkommata(length(totkommata));   

j=2;
for y=1:nrofratedpics
  for z=1:60
      totalcell{y,z}=verlaufsmatneu(totkommata2(j-1)+1:totkommata2(j)-1); 
      j=j+1;
  end
end  
discard=fgetl(fid);
discard=fgetl(fid);
fclose(fid);

picname=cell(1,nrofratedpics);
arorating=zeros(1,nrofratedpics);
valrating=zeros(1,nrofratedpics);
conrating=zeros(1,nrofratedpics);
arotime=zeros(1,nrofratedpics);
valtime=zeros(1,nrofratedpics);
contime=zeros(1,nrofratedpics);
tottime=zeros(1,nrofratedpics);
totalklicks=zeros(1,nrofratedpics);
aroklicks=zeros(1,nrofratedpics);
valklicks=zeros(1,nrofratedpics);
conklicks=zeros(1,nrofratedpics);
aroklickstd=zeros(1,nrofratedpics);
valklickstd=zeros(1,nrofratedpics);
conklickstd=zeros(1,nrofratedpics);


%totalcell auswerten
for y=1:nrofratedpics
    val_ok_status = 0;
    aro_ok_status = 0;
    con_ok_status = 0;
  for z=1:60
      
      aroklickdata=[];
      valklickdata=[];
      conklickdata=[];
      if strmatch('http:',totalcell{y,z})
          picname{y}=totalcell{y,z}(findstr(totalcell{y,z},'words')+7:findstr(totalcell{y,z},'.jpg')-1);
      end
      if strmatch('onset_aro',totalcell{y,z})
          arostart=z;
      end
      if strmatch('aro_ok',totalcell{y,z})
          aro_ok_status = 1;
          if ~isempty(str2num(totalcell{y,z-2}))
            arorating(find(strcmp(picname,picname{y})))=str2num(totalcell{y,z-2});
          else
            arorating(find(strcmp(picname,picname{y})))=99999999;
          end
          
          arotime(find(strcmp(picname,picname{y})))=str2num(totalcell{y,z+1});
          aroklicks(find(strcmp(picname,picname{y})))=round((z-arostart-2)/2);
          for g=1:aroklicks(find(strcmp(picname,picname{y})))
              aroklickdata(g)=str2num(totalcell{y,arostart+2+(g-1)*2});
          end
          if length(aroklickdata)>1
              aroklickstd(find(strcmp(picname,picname{y})))=std(aroklickdata);
          else
              aroklickstd(find(strcmp(picname,picname{y})))=0;
          end
      end
      if strmatch('onset_val',totalcell{y,z})
          valstart=z;
      end
      if strmatch('val_ok',totalcell{y,z})
          val_ok_status = 1;
           if ~isempty(str2num(totalcell{y,z-2}))
            valrating(find(strcmp(picname,picname{y})))=str2num(totalcell{y,z-2});
          else
            valrating(find(strcmp(picname,picname{y})))=99999999;
          end
          
          valtime(find(strcmp(picname,picname{y})))=str2num(totalcell{y,z+1});
          valklicks(find(strcmp(picname,picname{y})))=round((z-valstart-2)/2);
          for g=1:valklicks(find(strcmp(picname,picname{y})))
              valklickdata(g)=str2num(totalcell{y,valstart+2+(g-1)*2});
          end
          if length(valklickdata)>1
              valklickstd(find(strcmp(picname,picname{y})))=std(valklickdata);
          else
              valklickstd(find(strcmp(picname,picname{y})))=0;
          end
      end  
       if strmatch('onset_con',totalcell{y,z})
          constart=z;
      end
      if strmatch('con_ok',totalcell{y,z})
          con_ok_status = 1;
          if ~isempty(str2num(totalcell{y,z-2}))
            conrating(find(strcmp(picname,picname{y})))=str2num(totalcell{y,z-2});
          else
            conrating(find(strcmp(picname,picname{y})))=99999999;
          end
          
          contime(find(strcmp(picname,picname{y})))=str2num(totalcell{y,z+1});
          tottime(find(strcmp(picname,picname{y})))=valtime(find(strcmp(picname,picname{y})))+arotime(find(strcmp(picname,picname{y})))+contime(find(strcmp(picname,picname{y})));
          conklicks(find(strcmp(picname,picname{y})))=round((z-constart-2)/2);
          totalklicks(find(strcmp(picname,picname{y})))=valklicks(find(strcmp(picname,picname{y})))+aroklicks(find(strcmp(picname,picname{y})))+conklicks(find(strcmp(picname,picname{y})));
          for g=1:conklicks(find(strcmp(picname,picname{y})))
              conklickdata(g)=str2num(totalcell{y,constart+2+(g-1)*2});
          end
          if length(valklickdata)>1
              conklickstd(find(strcmp(picname,picname{y})))=std(conklickdata);
          else
              conklickstd(find(strcmp(picname,picname{y})))=0;
          end
      end
  end
  if aro_ok_status == 0
      arorating(find(strcmp(picname,picname{y})))=99999999;
      arotime(find(strcmp(picname,picname{y})))=99999999;
      aroklicks(find(strcmp(picname,picname{y})))=999999999;
      aroklicksstd(find(strcmp(picname,picname{y})))=99999999;
  end
  if val_ok_status == 0
     valrating(find(strcmp(picname,picname{y})))=99999999;
     valtime(find(strcmp(picname,picname{y})))=99999999;
     valklicks(find(strcmp(picname,picname{y})))=99999999;
     valklicksstd(find(strcmp(picname,picname{y})))=99999999;
  end  
   if con_ok_status == 0
     conrating(find(strcmp(picname,picname{y})))=99999999;
     contime(find(strcmp(picname,picname{y})))=99999999;
     tottime(find(strcmp(picname,picname{y})))=99999999;
     conklicks(find(strcmp(picname,picname{y})))=99999999;
     conklicksstd(find(strcmp(picname,picname{y})))=99999999;
     totalklicks(find(strcmp(picname,picname{y})))=99999999;
  end 
  
  
      
end 




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%datenbank einlesen und ergnzen
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%datenfile einlesen;

dbfile=[sourcefilepath,sourcefilename];
fid=fopen(dbfile,'rt');
scenario=fscanf(fid,'%s',1);
discard=fscanf(fid,'%s',1);
anzahlvpcell=fscanf(fid,'%s',1);
anzahlvp=str2num(anzahlvpcell);
discard=fscanf(fid,'%s',1);
anzahlstimulicell=fscanf(fid,'%s',1);
anzahlstimuli=str2num(anzahlstimulicell);



dbalter=cell(1,anzahlvp);
dbgeschlecht=cell(1,anzahlvp);
dbdatum=cell(1,anzahlvp);
dbID=cell(1,anzahlvp);
dbhaendigkeit=cell(1,anzahlvp);
dbschulabschluss=cell(1,anzahlvp);
stimulus_aro=zeros(anzahlstimuli,anzahlvp);				
stimulus_val=zeros(anzahlstimuli,anzahlvp);		
stimulus_con=zeros(anzahlstimuli,anzahlvp);	
stimulus_arotime=zeros(anzahlstimuli,anzahlvp);					
stimulus_valtime=zeros(anzahlstimuli,anzahlvp);	
stimulus_contime=zeros(anzahlstimuli,anzahlvp);	
stimulus_tottime=zeros(anzahlstimuli,anzahlvp);
stimulus_totalklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_aroklicks=zeros(anzahlstimuli,anzahlvp);					
stimulus_valklicks=zeros(anzahlstimuli,anzahlvp);
stimulus_conklicks=zeros(anzahlstimuli,anzahlvp);
stimulus_aroklickstd=zeros(anzahlstimuli,anzahlvp);					
stimulus_valklickstd=zeros(anzahlstimuli,anzahlvp);	
stimulus_conklickstd=zeros(anzahlstimuli,anzahlvp);
    
%alter
    
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
   dbalter{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
dbalter{1,e+1}=altervar;
    
%geschlecht
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
   dbgeschlecht{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
dbgeschlecht{1,e+1}=geschlechtvar;

%hndigkeit
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
    dbhaendigkeit{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
dbhaendigkeit{1,e+1}=haendigkeitvar;

%schulabschluss
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
    dbschulabschluss{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
dbschulabschluss{1,e+1}=schulabschlussvar;

%datum
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
     dbdatum{1,e}=fscanf(fid,'%s',1);
end
if isempty(e)
    e=0;
end
dbdatum{1,e+1}=datum;
     
%ID
discard=fscanf(fid,'%s',1);
for e=1:anzahlvp
   dbID{1,e}=fscanf(fid,'%s',1);
   if strcmp(ID,dbID{1,e})
       answer=questdlg('ID-Wiederholung! Abbrechen?',...
                        'Achtung:',...
                        'ja','nein','ja');
       switch answer
        case 'ja'
            fclose all;
            return;
        end     
   end   
end
if isempty(e)
    e=0;
end
dbID{1,e+1}=ID;

picreihenfolgecell=cell(1);
    
%stimuliparameter
for d=1:anzahlstimuli
    
    %arorating
    
    picnametemp=fscanf(fid,'%s',1);
    picreihenfolgecell{d}=picnametemp(9:findstr(picnametemp,'_aro')-1);
    
    for e=1:anzahlvp
        stimulus_aro(d,e)=str2num(fscanf(fid,'%s',1));
    end
	if isempty(e)
        e=0;
	end
    stimulus_aro(d,e+1)=arorating(find(strcmp(picreihenfolgecell{d},picname)));
    
    %valrating
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_val(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_val(d,e+1)=valrating(find(strcmp(picreihenfolgecell{d},picname)));
    
    %conrating
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_con(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_con(d,e+1)=conrating(find(strcmp(picreihenfolgecell{d},picname)));
    
    %arotime
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_arotime(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_arotime(d,e+1)=arotime(find(strcmp(picreihenfolgecell{d},picname)));
    
    %valtime
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_valtime(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_valtime(d,e+1)= valtime(find(strcmp(picreihenfolgecell{d},picname)));
    
     %contime
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_contime(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_contime(d,e+1)= contime(find(strcmp(picreihenfolgecell{d},picname)));
    
    
    %tottime
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_tottime(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_tottime(d,e+1)= tottime(find(strcmp(picreihenfolgecell{d},picname)));
    
    %totalklicks
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_totalklicks(d,e)=str2num(fscanf(fid,'%s',1));
    end 
    if isempty(e)
    e=0;
    end
    stimulus_totalklicks(d,e+1)=totalklicks(find(strcmp(picreihenfolgecell{d},picname)));
    
    %aroklicks
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_aroklicks(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_aroklicks(d,e+1)=aroklicks(find(strcmp(picreihenfolgecell{d},picname)));
    
    %valklicks
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_valklicks(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_valklicks(d,e+1)=valklicks(find(strcmp(picreihenfolgecell{d},picname)));
    
    %conklicks
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_conklicks(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_conklicks(d,e+1)=conklicks(find(strcmp(picreihenfolgecell{d},picname)));
    
    
    
    %aroklickstd
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_aroklickstd(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
     stimulus_aroklickstd(d,e+1)=aroklickstd(find(strcmp(picreihenfolgecell{d},picname)));
     
    %valklickstd
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_valklickstd(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_valklickstd(d,e+1)=valklickstd(find(strcmp(picreihenfolgecell{d},picname)));

    %conklickstd
    
    discard=fscanf(fid,'%s',1);
    for e=1:anzahlvp
         stimulus_conklickstd(d,e)=str2num(fscanf(fid,'%s',1));
    end
    if isempty(e)
    e=0;
    end
    stimulus_conklickstd(d,e+1)=conklickstd(find(strcmp(picreihenfolgecell{d},picname)));
    
end   				
        				
fclose(fid); 

%vpzahl erhhen!!!!!!
anzahlvp=anzahlvp+1;



%reihenfolge angleichen
%'picname' ist aus mail
%'picreihenfolgecell' ist aus db

for t=1:length(picreihenfolgecell)
    picnamereihenfolgevec(t)=find(strcmp(picreihenfolgecell{t},picname));
end


%datenbank wegschreiben
targetfile=[sourcefilepath,sourcefilename];
fid=fopen(targetfile,'wt');

%header
fprintf(fid,[scenario,'\tvps\t',num2str(anzahlvp),'\tstimuli\t',num2str(anzahlstimuli),'\n']);



%alter
fprintf(fid,'Alter');
for s=1:anzahlvp
    fprintf(fid,[' ',dbalter{s}]);
end
fprintf(fid,'\n');

%geschlecht
 fprintf(fid,'Geschlecht');
for s=1:anzahlvp
    fprintf(fid,[' ',dbgeschlecht{s}]);
end
fprintf(fid,'\n');


%hndigkeit
 fprintf(fid,'Hndigkeit');
for s=1:anzahlvp
    fprintf(fid,[' ',dbhaendigkeit{s}]);
end
fprintf(fid,'\n');

%schulabschluss
 fprintf(fid,'Schulabschluss');
for s=1:anzahlvp
    fprintf(fid,[' ',dbschulabschluss{s}]);
end
fprintf(fid,'\n');

%datum
 fprintf(fid,'Datum');
for s=1:anzahlvp
    fprintf(fid,[' ',dbdatum{s}]);
end
fprintf(fid,'\n');

%ID
fprintf(fid,'ID');
for s=1:anzahlvp
    fprintf(fid,[' ',dbID{s}]);
end
fprintf(fid,'\n');

%stimuliparameter




for d=1:anzahlstimuli
    %arorating
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_aro']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_arotime(d,e))]);
    end
	if isempty(e)
	e=0;
	end
    fprintf(fid,'\n');
    
    %valrating
     fprintf(fid,['stimulus',picreihenfolgecell{d},'_val']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_val(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
    
    %conrating
     fprintf(fid,['stimulus',picreihenfolgecell{d},'_con']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_con(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
    
    %arotime
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_arotime']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_aro(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
    
    %valtime
      fprintf(fid,['stimulus',picreihenfolgecell{d},'_valtime']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_valtime(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
    
     %contime
      fprintf(fid,['stimulus',picreihenfolgecell{d},'_contime']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_contime(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
    
    %tottime
      fprintf(fid,['stimulus',picreihenfolgecell{d},'_tottime']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_tottime(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
   
    %totalklicks
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_totalklicks']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_totalklicks(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
    
    %aroklicks
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_aroklicks']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_aroklicks(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
    
    %valklicks
      fprintf(fid,['stimulus',picreihenfolgecell{d},'_valklicks']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_valklicks(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
    
    %conklicks
      fprintf(fid,['stimulus',picreihenfolgecell{d},'_conklicks']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_conklicks(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
    
    %aroklickstd
     fprintf(fid,['stimulus',picreihenfolgecell{d},'_aroklickstd']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_aroklickstd(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
     
    %valklickstd
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_valklickstd']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_valklickstd(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
    
    %conklickstd
    fprintf(fid,['stimulus',picreihenfolgecell{d},'_conklickstd']);
    for e=1:anzahlvp
        fprintf(fid,[' ',num2str(stimulus_conklickstd(d,e))]);
    end
	if isempty(e)
        e=0;
	end
    fprintf(fid,'\n');
end

fclose(fid);

return










