function readxfile

%   readxfile

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
global vertexmat
[filename,filepath]=uigetfile('*.x','Please choose x-file:');
file = [filepath,filename];

matcpy = strrep(file,'.x','.mat');
if exist(matcpy)==2
    answer = questdlg('Do you wish to load from a previous mat-file?','data backup:','Yes','No','Yes');
    if strcmp(answer,'Yes')
        load(matcpy,'vertexmat');
        nrvertex = size(vertexmat,1);
    end
else
	fid = fopen(file,'rt');
	while line~=-1
        line = fgetl(fid);
        if findstr(line,'Mesh ') & isempty(findstr(line,'template Mesh'))
            
            nrvertexstring = fgetl(fid);
            nrvertexstring(findstr(nrvertexstring,';'))=[];
            nrvertex = str2num(nrvertexstring);
            vertexmat=zeros(1,3);
            
            fprintf(1,['Start reading ',num2str(nrvertex),' vertices...']);
            for i=1:nrvertex
                if mod(i,100)==0
                    fprintf(1,[num2str(i),' of ',num2str(nrvertex),' vertices done...\n']);
                    pause(0.01);
                end
                line = fgetl(fid);
                vertexmat(i,:)=str2num(strrep(strrep(line,';',' '),',',''));
            end
            break
        end
	end
	save(matcpy,'vertexmat');
end

answer = questdlg('Do you wish to step-wise plot vertices?','plot:','Yes','No','Yes');
if strcmp(answer,'Yes')
	figure
	hold on
	for i=1:nrvertex
        plot3(vertexmat(i,1),vertexmat(i,2),vertexmat(i,3),'.');
        if mod(i,2)==0
            disp(num2str(i));
            pause
        end
	end  
end

%find  double vertices
i=2;
j=1;

fprintf(1,['Checking for identical vertices...\n']);
while j<length(vertexmat)
    
    fprintf(1,[num2str(j),' of ',num2str(nrvertex),' vertices done...\n']);
    while i<length(vertexmat)
        %fprintf(1,[num2str(dist3d([vertexmat(j,1) vertexmat(i,1)],[vertexmat(j,2) vertexmat(i,2)],[vertexmat(j,3) vertexmat(i,3)])),'\n']);
        
        if dist3d([vertexmat(j,1) vertexmat(i,1)],[vertexmat(j,2) vertexmat(i,2)],[vertexmat(j,3) vertexmat(i,3)])<0.01
            vertexmat(i,:)=[-9999999 -9999999 -9999999];
        end
        i=i+1; 
    end
    j=j+1;
    i=j+1;
end

%   vertexmat    
%   length(vertexmat)
%   plot3(vertexmat(:,1),vertexmat(:,2),vertexmat(:,3),'o');
%   
%   for i=1:length(vertexmat)
%       fprintf(1,['{',strrep([num2str(vertexmat(i,1)),'f,'],'0f,','0.0f,'),strrep([num2str(vertexmat(i,2)),'f,'],'0f,','0.0f,'),strrep(strrep([num2str(vertexmat(i,3)),'f,'],'0f,','0.0f'),',',''),'},\n']);
%   end 
%   rotate3d
return