function renamemanage(filename,filepath,mode)

%   renamemanage

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if mode == 11
    filename=[];
    filepath=get(findobj('tag','directorymonitor'),'string');
elseif mode == 12
    batchfile=get(findobj('tag','batchfilemonitor'),'string');
    [batchfilepath,batchfilename,ext,versn] = fileparts(batchfile);
    batchfilepath=[batchfilepath,filesep];
    batchfilename=[batchfilename,ext];
elseif mode == 2
    file = get(findobj('tag','filemonitor'),'string');
    [filepath,filename,ext,versn] = fileparts(file);
    filepath=[filepath,filesep];
    filename=[filename,ext];
end


versionstring = version;
matlabversion = str2num(versionstring(1:3));


findedit=findobj('tag','findedit');
findstr=get(findedit,'String');

replaceedit=findobj('tag','replaceedit');
replacestring=get(replaceedit,'String');
inclsubdirradio=findobj('tag','inclsubdirradio');
inclsubdir=get(inclsubdirradio,'Value');
copyreplaceradio=findobj('tag','copyreplaceradio');
copyreplace=get(copyreplaceradio,'Value');
findstringedit=findobj('tag','findstringedit');
findstring=get(findstringedit,'String');
findedit=findobj('tag','findedit');
find=get(findedit,'String');

if isempty(find) & mode~=12 & mode ~=2
    uiwait(errordlg('Sie haben keine Filesuchkriterium angegeben!'));
    return
end
if isempty(findstring)
    uiwait(errordlg('Sie haben keinen Find-string angegeben!'));
    return
end
if strcmp(findstring,replacestring)
    uiwait(errordlg('Find-string und replace-string sind identisch!'));
    return
end

findtypepopup=findobj('tag','findtypepopup');
searchpart = get(findtypepopup,'Value');
%1: filename
%2: extension
%3: version


logicpopup=findobj('tag','logicpopup');
logictype = get(logicpopup,'Value');
%1: contains
%2: does not contain
%3: equals
%4: does not equal
%5: ends with


if mode==0
   modefehler
   return
% directory mode   
elseif mode==11
    
    [filemat]=dir2batch(filepath,inclsubdir,0,1,1,find,[],searchpart,logictype);
	if isempty(filemat)
        return
	end
    
    NewFilePathMat=cell(1);
	cd (filepath);
   % Schleife fr Files
   for filezaehler=1:size(filemat,2)
      NewFilePathMat{filezaehler}=filerename(filemat{filezaehler},[],findstring,replacestring,matlabversion);
   end
   
   msgbox(filemat,'Files selected for renaming:');
   msgbox(NewFilePathMat,'New filenames:');
   ok
   
% batchfile mode   
elseif mode==12
   filemat=batchfiletomat(batchfilename,batchfilepath);
   filematgroessevec=size(filemat);
   filematgroesse=filematgroessevec(2);
   NewFilePathMat=cell(1);
   for filezaehler=1:filematgroesse
      NewFilePathMat{filezaehler}=filerename(filemat{filezaehler},[],findstring,replacestring,matlabversion);

   end
    msgbox(filemat,'Files selected for renaming:');
   msgbox(NewFilePathMat,'New filenames:');
   ok
      
% single file mode   
elseif mode==2
   NewFilePath=filerename(filename,filepath,findstring,replacestring,matlabversion);
   ok
   
  
end

return