function setscaling
%  

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

global axeshandles NChan ampscaling channelscaling  channelwindow timescaling timewindow lowerlimit axeswidth...
    axesheight axesx datamat channelnumberlabels vertposvecini bottomstandoff topstandoff NPoints start

%Get slider absolute and relative positions
%---------------------
timewindow=get(findobj('tag','timewindowslider'),'Value');
timewindowrelative=(get(findobj('tag','timewindowslider'),'Max')-get(findobj('tag','timewindowslider'),'Value'))/...
    (get(findobj('tag','timewindowslider'),'Max')-get(findobj('tag','timewindowslider'),'Min'));
channelscaling=get(findobj('tag','channelscalingslider'),'Value');
timescaling=get(findobj('tag','timescalingslider'),'Value');
ampscaling=get(findobj('tag','ampscalingslider'),'Value');
channelwindow=get(findobj('tag','channelwindowslider'),'Value');
channelwindowrelative=(get(findobj('tag','channelwindowslider'),'Max')-get(findobj('tag','channelwindowslider'),'Value'))/...
    (get(findobj('tag','channelwindowslider'),'Max')-get(findobj('tag','channelwindowslider'),'Min'));
channelnumberaxes=findobj('tag','channelnumberaxes');

%positioning
%-----------
toplimit=0.98;
bottomlimit=0.139;
height=0.8410;
leftlimit=0.0268;
rightlimit=0.9604;
width=0.9336;
axesheight=height/(NChan *ampscaling*ampscaling);
axeswidth=width*timescaling;
axesx = leftlimit-width*timewindow;

%Max,Min,Value-Correction
%-------------------------
channelwindowslider=findobj('tag','channelwindowslider');
set(channelwindowslider,'Max',(0.98-axesheight-toplimit+1*height/channelscaling-0.5*axesheight)/(-1*NChan*height/channelscaling));
set(channelwindowslider,'Min',(0.149-toplimit+(NChan)*height/(channelscaling)-0.5*axesheight)/(-1*NChan*height/(channelscaling)));
set(channelwindowslider,'Value',get(channelwindowslider,'Max')- channelwindowrelative*(get(channelwindowslider,'Max')-get(channelwindowslider,'Min')));
set(findobj('tag','channelscalingslider'),'Min',sqrt((0.139-toplimit)/((-1)*j*height)));

timewindowslider=findobj('tag','timewindowslider');
set(timewindowslider,'Max',timescaling-1);
set(timewindowslider,'Value',get(timewindowslider,'Max')- timewindowrelative*(get(timewindowslider,'Max')-get(timewindowslider,'Min')));

%Get slider positions
%---------------------
timewindow=get(findobj('tag','timewindowslider'),'Value');
channelscaling=get(findobj('tag','channelscalingslider'),'Value');
timescaling=get(findobj('tag','timescalingslider'),'Value');
ampscaling=get(findobj('tag','ampscalingslider'),'Value');
channelwindow=get(findobj('tag','channelwindowslider'),'Value');
channelnumberaxes=findobj('tag','channelnumberaxes');


channelnumberaxes=findobj('tag','channelnumberaxes');
delete(channelnumberaxes);
channelnumberlabels=[];
figurecolor=get(gcf,'Color');
channelnumberaxes=axes('units','normalized','tag','channelnumberaxes','position',[0.0 0 0.04435006435006435 1],'XLim',[0 1],'YLim',[0 1],'Visible','on','fontsize',4,'YColor',figurecolor);



for j=1:NChan
    figurecolor=get(gcf,'Color');
    if (toplimit - j*height/channelscaling - channelwindow*NChan*height/channelscaling)<lowerlimit
         set(axeshandles(j),'position',[axesx  3 axeswidth axesheight],'Color','none'); 
         vertposvec(j)=(toplimit - j*height/channelscaling - channelwindow*NChan*height/channelscaling + 0.5*axesheight);
     else
         set(axeshandles(j),'position',[axesx  (toplimit - j*height/channelscaling - channelwindow*NChan*height/channelscaling) axeswidth axesheight],'Color','none'); 
         vertposvec(j)=(toplimit - j*height/channelscaling - channelwindow*NChan*height/channelscaling + 0.5*axesheight);
     end
     if ~(vertposvec(j)<lowerlimit+0.009/ampscaling)
        channelnumberlabels(j)=text(0.65,vertposvec(j),num2str(j),'color',[0 0 0],'HorizontalAlignment','center','fontsize',8);
    end
end


return