function [nrofargs,argcell,stringcell,numcell] = strparse(instring)
%  

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
instring = strrep(instring,'''','"');
if isempty(instring)
    nrofargs = 0;
    argcell =[];stringcell=[];numcell=[];
    return
end
delimiters= [];
for r=1:length(instring)
    [status,strlength]=isdelimiter(instring(r));
    if status & strlength==1
        delimiters(size(delimiters,2)+1)=r;
    elseif status & strlength==2
        delimiters(size(delimiters,2)+1)=r;
        instring = strinsert(instring,[delimiters(length(delimiters)+1):delimiters(length(delimiters)+1)+1],'@');
    end
end

argcell = cell(1);
argzaehler = 1;
stringcell = cell(1);
stringzaehler = 1;
numcell = cell(1);
numzaehler = 1;
if isempty(delimiters)
    argcell{1}= instring;
    nrofargs = 1;stringcell=[];numcell=[];
    return
else
	argcell{argzaehler}= instring(1:delimiters(1)-1);
	
	
	%extract string
	if ~isempty(findstr(instring(delimiters),char(34)))
        stringopenstatus = 0;
        apostrophs = findstr(instring(delimiters),char(34));
        e = 1;
        openendstatus = 0;
        while e<=size(apostrophs,2)
            if ~isletterpp(instring(delimiters(apostrophs(e))-1)) & ~strcmp(instring(delimiters(apostrophs(e))-1),')')
                stringopenstatus = 1;
                zaehler = 1;
                while stringopenstatus
                    if e+zaehler<=size(apostrophs,2)
                        if strcmp(instring(delimiters(apostrophs(e+zaehler))),char(34))
                            stringopenstatus = 0;
                        else
                            zaehler = zaehler+1;
                        end
                    else
                        stringopenstatus = 0;
                        openendstatus = 1;
                    end
                        
                end
                if ~openendstatus
                    stringcell{stringzaehler}=instring(delimiters(apostrophs(e))+1:delimiters(apostrophs(e+zaehler))-1);
                    stringzaehler = stringzaehler+1;
                    instring(delimiters(apostrophs(e)):delimiters(apostrophs(e+zaehler)))=[]; 
                    e = 0;
					delimiters= [];
					for r=1:size(instring,2)
                        if isdelimiter(instring(r))
                            delimiters(size(delimiters,2)+1)=r;
                        end
					end
                else
                    stringcell{stringzaehler}=instring(delimiters(apostrophs(e))+1:end);
                    stringzaehler = stringzaehler+1;
                    instring(delimiters(apostrophs(e)):end)=[]; 
                end
                delimiters= [];
				for r=1:size(instring,2)
                    if isdelimiter(instring(r))
                        delimiters(size(delimiters,2)+1)=r;
                    end
				end
                apostrophs = findstr(instring(delimiters),char(34));
            end
            e = e+1;
        end
	end
	if ~isempty(deblankex(argcell{argzaehler}))
        argzaehler = argzaehler+1;
	end
	for s=1:size(delimiters,2)-1
        argcell{argzaehler}=instring(delimiters(s)+1:delimiters(s+1)-1);
        if ~isempty(deblankex(argcell{argzaehler}))
            argcell{argzaehler}= deblankex(argcell{argzaehler});
            if ~isnumstring(argcell{argzaehler}) & ~strcmp(argcell{argzaehler},'tobool') & ...
                    ~strcmp(argcell{argzaehler},'isempty') & ~strcmp(argcell{argzaehler},'ExtractScalar')
                notnew = 0;
                for r=1:length(argcell)-1
                    if strcmp(argcell{r},argcell{argzaehler})
                        notnew = 1;
                    end
                end
                if ~notnew
                    argzaehler = argzaehler+1;
                end
            else
                numcell{numzaehler}=argcell{argzaehler};
                numzaehler = numzaehler+1;
            end
                
		end
	end
    if isempty(s) & size(delimiters,2)==1
        s = 0;
    end
	argcell{argzaehler}= instring(delimiters(s+1)+1:end);
	if isempty(deblankex(argcell{argzaehler}))
        argcell(argzaehler)=[];
        argzaehler = argzaehler -1;
	end
	nrofargs = argzaehler;
	
	if nargout<1
        for w=1:nrofargs
            fprintf(1,argcell{w});
            fprintf(1,'\n');
        end
	end
end

            
    

return

