function writestatistics(paramat,stimnummercell,filenamecell,celladressmat,groessenreqinds,absolutreqs,kleinerreqs,groesserreqs,gleichreqs,dim,displaystatus)
%   

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

%displaystatus
%----------------
% 0 = only display
% 1 = only file
% 2 = display and writefile

if displaystatus ~= 0
    [savefilename,savefilepath]=uiputfile('*.txt','Bitte benennen Sie die Datei fr den statistischen Bericht:');
	if isequal(savefilename,0)|isequal(savefilepath,0)
        msgbox('Invalid Filename!','Fehler')
        return
	end
	if isempty(findstr(savefilename,'.txt'))
       savefilename=[savefilename,'.txt'];
	end
	savefile=[savefilepath,savefilename];
	fid = fopen(savefile,'wt');
end

% %gruppengroessen
% groessenreqinds=zeros(1,3); % :  reqnumber ; gruppengroesse ; celladdress;
% j=1;
% 
% absolutreqs =cell(1,4); % reqnumber; absolutWert ; celladdress ; dimension; operator;
% k=1;
% 
% kleinerreqs = cell(1,4); %reqnumber; cell1adress; cell2adress; dimension; alpha;
% l_k=1;
% 
% groesserreqs = cell(1,4); %reqnumber; cell1adress; cell2adress; dimension; alpha;
% l_g=1;
% 
% gleichreqs = cell(1,4); %reqnumber; cell1adress; cell2adress; dimension; alpha;
% l_e=1;


%display:
%---------
if displaystatus ~=1
    
    fprintf(1,'Zellengroessen:\n\n');
     for k=1:length(celladressmat)
         fprintf(1,['Zelle',num2str(celladressmat(k)),': ',num2str(groessenreqinds(find(celladressmat(k)==groessenreqinds(:,3)),2)),' Items\n']);
     end
     fprintf(1,'\n');
     %Zellengrenzen
     % reqnumber; absolutWert ; celladdress ; dimension; operator
     if ~isempty(absolutreqs{1,1})
        fprintf(1,'Zellengrenzen:\n\n');
        for k=1:size(absolutreqs,1)
            fprintf(1,['Bedingung ',num2str(k),': Zelle',num2str(absolutreqs{k,3}),' ',absolutreqs{k,5},' ',num2str(absolutreqs{k,2}),' auf ',absolutreqs{k,4},'\n']);
        end
     end
     fprintf(1,'\n');
     fprintf(1,'Deskriptive Statistik (Mittelwert):\n\n');
     fprintf(1,'Zelle\t');
     for k=2:size(dim,2)-1
         fprintf(1,[dim{k},'\t']);
     end
     fprintf(1,'\n');
     fprintf(1,'--------------------------------------------\n');
     for k=1:length(celladressmat)
         if ~isempty(stimnummercell{k})
             fprintf(1,['Zelle',num2str(celladressmat(k)),':']);
             for l=2:size(dim,2)-1
                fprintf(1,[,'\t',num2str(mean(paramat(stimnummercell{k},l-1)))]);
             end
             fprintf(1,'\n');
         end
     end
     fprintf(1,'--------------------------------------------\n');
     if ~isempty(kleinerreqs{1,1})
        fprintf(1,'Kleinerbedingungen:\n\n');
        for j=1:size(kleinerreqs,1)
            fprintf(1,['Bedingung ',num2str(j),': Zelle',num2str(kleinerreqs{j,2}),' < Zelle',num2str(kleinerreqs{j,3}),' auf ', kleinerreqs{j,4},': p = ']);
            cell1adress=kleinerreqs{j,2};
            cell2adress=kleinerreqs{j,3};
            aktivecell1=find(groessenreqinds(:,3)==cell1adress);
            aktivecell2=find(groessenreqinds(:,3)==cell2adress);
            cell1anzahlstim=groessenreqinds(aktivecell1,2);
            cell2anzahlstim=groessenreqinds(aktivecell2,2);
            sample1=zeros(cell1anzahlstim,1);
            sample2=zeros(cell2anzahlstim,1);
            cellnummer1=find(celladressmat==aktivecell1);
            cellnummer2=find(celladressmat==aktivecell2);
            
            for dimzaehler=1:length(dim)
                if ~isempty(findstr(dim{dimzaehler},kleinerreqs{j,4}))
                    %paramatkorrektur
                    dimnummer=dimzaehler-1;
                end
            end
            for zaehler=1:cell1anzahlstim
                sample1(zaehler,1)=paramat(stimnummercell{cellnummer1}(zaehler),dimnummer);
            end
            for zaehler=1:cell2anzahlstim
                sample2(zaehler,1)=paramat(stimnummercell{cellnummer2}(zaehler),dimnummer);
            end
            h=1;
            
            if var(sample1)*var(sample2)~=0
                [h,significance,ci] = ttest2(sample1,sample2,kleinerreqs{j,5},-1);
                fprintf(1,'%6.4f',significance);
                fprintf(1,'\n');
            else
                fprintf(1,['keine Varianz!\n']); 
            end  
        end
		end
		%groesserreqs
		if ~isempty(groesserreqs{1,1})
            fprintf(1,'Groesserbedingungen:\n\n');
            for j=1:size(groesserreqs,1)
                fprintf(1,['Bedingung ',num2str(j),': Zelle',num2str(groesserreqs{j,2}),' > Zelle',num2str(groesserreqs{j,3}),' auf ', groesserreqs{j,4},': p = ']);
                cell1adress=groesserreqs{j,2}; 
                cell2adress=groesserreqs{j,3};
                aktivecell1=find(groessenreqinds(:,3)==cell1adress);
                aktivecell2=find(groessenreqinds(:,3)==cell2adress);
                cell1anzahlstim=groessenreqinds(aktivecell1,2);
                cell2anzahlstim=groessenreqinds(aktivecell2,2);
                sample1=zeros(cell1anzahlstim,1);
                sample2=zeros(cell2anzahlstim,1);
                cellnummer1=find(celladressmat==aktivecell1);
                cellnummer2=find(celladressmat==aktivecell2);
                for dimzaehler=1:length(dim)
                    if ~isempty(findstr(dim{dimzaehler},groesserreqs{j,4}))
                        %paramatkorrektur
                        dimnummer=dimzaehler-1;
                    end
                end
                for zaehler=1:cell1anzahlstim
                    sample1(zaehler,1)=paramat(stimnummercell{cellnummer1}(zaehler),dimnummer);
                end
                for zaehler=1:cell2anzahlstim
                    sample2(zaehler,1)=paramat(stimnummercell{cellnummer2}(zaehler),dimnummer);
                end
                h=1;
                if var(sample1)*var(sample2)~=0
                    [h,significance,ci] = ttest2(sample1,sample2,groesserreqs{j,5},1);
                    fprintf(1,'%6.4f',significance);
                    fprintf(1,'\n');
                    
                else
                     fprintf(1,['keine Varianz!\n']);
                end
            end
		end       
				
		%gleichreqs
		if ~isempty(gleichreqs{1,1})
            fprintf(1,'Gleichheitsbedingungen:\n\n');
            for j=1:size(gleichreqs,1)
                fprintf(1,['Bedingung ',num2str(j),': Zelle',num2str(gleichreqs{j,2}),' = Zelle',num2str(gleichreqs{j,3}),' auf ',gleichreqs{j,4},': p = ']);
                cell1adress=gleichreqs{j,2};
                cell2adress=gleichreqs{j,3};
                aktivecell1=find(groessenreqinds(:,3)==cell1adress);
                aktivecell2=find(groessenreqinds(:,3)==cell2adress);
                cell1anzahlstim=groessenreqinds(aktivecell1,2);
                cell2anzahlstim=groessenreqinds(aktivecell2,2);
                sample1=zeros(cell1anzahlstim,1);
                sample2=zeros(cell2anzahlstim,1);
                cellnummer1=find(celladressmat==groessenreqinds(aktivecell1,3));
                cellnummer2=find(celladressmat==groessenreqinds(aktivecell2,3));
                for dimzaehler=1:length(dim)
                    if ~isempty(findstr(dim{dimzaehler},gleichreqs{j,4}))
                        %paramatkorrektur
                        dimnummer=dimzaehler-1;
                    end
                end
               
                for zaehler=1:cell1anzahlstim
                     if ~isempty(stimnummercell{cellnummer1}(zaehler))
                        sample1(zaehler,1)=paramat(stimnummercell{cellnummer1}(zaehler),dimnummer);
                     end
                end
                for zaehler=1:cell2anzahlstim
                    if ~isempty(stimnummercell{cellnummer1}(zaehler))
                        sample2(zaehler,1)=paramat(stimnummercell{cellnummer2}(zaehler),dimnummer);
                    end
                end
                h=0;
                if ~isempty(find(sample1~=0)) & ~isempty(find(sample2~=0))
                if var(sample1)*var(sample2)~=0
                   [h,significance,ci] = ttest2(sample1,sample2,gleichreqs{j,5},0);
                   fprintf(1,'%6.4f',significance);
                    fprintf(1,'\n');
                else
                   fprintf(1,['keine Varianz!\n']); 
                end
                end
            end
		end 

end



%file:
%--------

if displaystatus ~=0
    
 fprintf(fid,'Zellengroessen:\n\n');
 
 for k=1:length(celladressmat)
     fprintf(fid,['Zelle',num2str(celladressmat(k)),': ',num2str(groessenreqinds(find(celladressmat(k)==groessenreqinds(:,3)),2)),' Items\n']);
 end
 
 fprintf(fid,'\n');
 
 %Zellengrenzen
 % reqnumber; absolutWert ; celladdress ; dimension; operator
 if ~isempty(absolutreqs{1,1})
    fprintf(fid,'Zellengrenzen:\n\n');
    for k=1:size(absolutreqs,1)
        fprintf(fid,['Bedingung ',num2str(k),': Zelle',num2str(absolutreqs{k,3}),' ',absolutreqs{k,5},' ',num2str(absolutreqs{k,2}),' auf ',absolutreqs{k,4},'\n']);
    end
 end
  
 fprintf(fid,'\n');
 fprintf(fid,'Deskriptive Statistik (Mittelwert):\n\n');
 
 fprintf(fid,'Zelle\t');
 for k=2:size(dim,2)-1
     fprintf(fid,[dim{k},'\t']);
 end
 fprintf(fid,'\n');
 fprintf(fid,'--------------------------------------------\n');
 
 for k=1:length(celladressmat)
     fprintf(fid,['Zelle',num2str(celladressmat(k)),':']);
     for l=2:size(dim,2)-1
        fprintf(fid,[,'\t',num2str(mean(paramat(stimnummercell{k},l-1)))]);
     end
     fprintf(fid,'\n');
 end
 fprintf(fid,'--------------------------------------------\n');
 fprintf(fid,'\n\n');
 
 if ~isempty(kleinerreqs{1,1})
    fprintf(fid,'Kleinerbedingungen:\n\n');
    for j=1:size(kleinerreqs,1)
        fprintf(fid,['Bedingung ',num2str(j),': Zelle',num2str(kleinerreqs{j,2}),' < Zelle',num2str(kleinerreqs{j,3}),' auf ', kleinerreqs{j,4},': p = ']);
        cell1adress=kleinerreqs{j,2};
        cell2adress=kleinerreqs{j,3};
        aktivecell1=find(groessenreqinds(:,3)==cell1adress);
        aktivecell2=find(groessenreqinds(:,3)==cell2adress);
        cell1anzahlstim=groessenreqinds(aktivecell1,2);
        cell2anzahlstim=groessenreqinds(aktivecell2,2);
        sample1=zeros(cell1anzahlstim,1);
        sample2=zeros(cell2anzahlstim,1);
        cellnummer1=find(celladressmat==aktivecell1);
        cellnummer2=find(celladressmat==aktivecell2);
        
        for dimzaehler=1:length(dim)
            if ~isempty(findstr(dim{dimzaehler},kleinerreqs{j,4}))
                %paramatkorrektur
                dimnummer=dimzaehler-1;
            end
        end
        for zaehler=1:cell1anzahlstim
            sample1(zaehler,1)=paramat(stimnummercell{cellnummer1}(zaehler),dimnummer);
        end
        for zaehler=1:cell2anzahlstim
            sample2(zaehler,1)=paramat(stimnummercell{cellnummer2}(zaehler),dimnummer);
        end
        h=1;
        
        if var(sample1)*var(sample2)~=0
            [h,significance,ci] = ttest2(sample1,sample2,kleinerreqs{j,5},-1);
            fprintf(fid,'%6.4f',significance);
            fprintf(fid,'\n');
        else
            fprintf(fid,['keine Varianz!\n']); 
        end  
    end
	end
     
	fprintf(fid,'\n\n');
	
	%groesserreqs
	if ~isempty(groesserreqs{1,1})
        fprintf(fid,'Groesserbedingungen:\n\n');
        for j=1:size(groesserreqs,1)
            fprintf(fid,['Bedingung ',num2str(j),': Zelle',num2str(groesserreqs{j,2}),' > Zelle',num2str(groesserreqs{j,3}),' auf ', groesserreqs{j,4},': p = ']);
            cell1adress=groesserreqs{j,2}; 
            cell2adress=groesserreqs{j,3};
            aktivecell1=find(groessenreqinds(:,3)==cell1adress);
            aktivecell2=find(groessenreqinds(:,3)==cell2adress);
            cell1anzahlstim=groessenreqinds(aktivecell1,2);
            cell2anzahlstim=groessenreqinds(aktivecell2,2);
            sample1=zeros(cell1anzahlstim,1);
            sample2=zeros(cell2anzahlstim,1);
            cellnummer1=find(celladressmat==aktivecell1);
            cellnummer2=find(celladressmat==aktivecell2);
            for dimzaehler=1:length(dim)
                if ~isempty(findstr(dim{dimzaehler},groesserreqs{j,4}))
                    %paramatkorrektur
                    dimnummer=dimzaehler-1;
                end
            end
            for zaehler=1:cell1anzahlstim
                sample1(zaehler,1)=paramat(stimnummercell{cellnummer1}(zaehler),dimnummer);
            end
            for zaehler=1:cell2anzahlstim
                sample2(zaehler,1)=paramat(stimnummercell{cellnummer2}(zaehler),dimnummer);
            end
            h=1;
            if var(sample1)*var(sample2)~=0
                [h,significance,ci] = ttest2(sample1,sample2,groesserreqs{j,5},1);
                fprintf(fid,'%6.4f',significance);
                fprintf(fid,'\n');
                
            else
                 fprintf(fid,['keine Varianz!\n']);
            end
        end
	end       
	
	fprintf(fid,'\n\n');
	
	
	%gleichreqs
	if ~isempty(gleichreqs{1,1})
        fprintf(fid,'Gleichheitsbedingungen:\n\n');
        for j=1:size(gleichreqs,1)
            fprintf(fid,['Bedingung ',num2str(j),': Zelle',num2str(gleichreqs{j,2}),' = Zelle',num2str(gleichreqs{j,3}),' auf ', gleichreqs{j,4},': p = ']);
            cell1adress=gleichreqs{j,2}
            cell2adress=gleichreqs{j,3}
            aktivecell1=find(groessenreqinds(:,3)==cell1adress);
            aktivecell2=find(groessenreqinds(:,3)==cell2adress);
            cell1anzahlstim=groessenreqinds(aktivecell1,2);
            cell2anzahlstim=groessenreqinds(aktivecell2,2);
            sample1=zeros(cell1anzahlstim,1);
            sample2=zeros(cell2anzahlstim,1);
            cellnummer1=find(celladressmat==groessenreqinds(aktivecell1,3));
            cellnummer2=find(celladressmat==groessenreqinds(aktivecell2,3));
            for dimzaehler=1:length(dim)
                if ~isempty(findstr(dim{dimzaehler},gleichreqs{j,4}))
                    %paramatkorrektur
                    dimnummer=dimzaehler-1;
                end
            end
           
            for zaehler=1:cell1anzahlstim
                 if ~isempty(stimnummercell{cellnummer1}(zaehler))
                    sample1(zaehler,1)=paramat(stimnummercell{cellnummer1}(zaehler),dimnummer);
                 end
            end
            for zaehler=1:cell2anzahlstim
                if ~isempty(stimnummercell{cellnummer1}(zaehler))
                    sample2(zaehler,1)=paramat(stimnummercell{cellnummer2}(zaehler),dimnummer);
                end
            end
            h=0;
            if ~isempty(find(sample1~=0)) & ~isempty(find(sample2~=0))
            if var(sample1)*var(sample2)~=0
               [h,significance,ci] = ttest2(sample1,sample2,gleichreqs{j,5},0);
               fprintf(fid,'%6.4f',significance);
                fprintf(fid,'\n');
            else
               fprintf(fid,['keine Varianz!\n']); 
            end
            end
        end
	end 

    fclose(fid);
end


return