function V = data_readdata(index);

% data_readdata        - Reading for the jezzard dataset.
%
%       function V = data_readdata(index);
%
%       Input:  index   Scan index
%
%       Output: V       The volume in a row vector
%
%       See also: data_readinfo


    fid = fopen(sprintf('../data/jezzard0716phot1_unwarp.%03d', ...
	index), 'r', 'ieee-be');
    if fid==-1
      error('data_readdata: Could not open file');
    end
    fread(fid, 8, 'char');
    V = fread(fid, 'short')';
    V = reshape(fliplr(flipud(reshape(V,64,64))),1,64*64);
    fclose(fid);




