// $Id: lyngby_batch_bmr_run.java,v 1.2 2004/03/17 19:49:37 fnielsen Exp $

import java.io.*;
import fiswidgets.fisgui.*;
import fiswidgets.fisutils.*;
import javax.swing.*;


public class lyngby_batch_bmr_run extends FisRunManager {
    lyngby_batch_bmr gui;
    FisRunner run;

    public lyngby_batch_bmr_run(lyngby_batch_bmr gui) {
	super();
	this.gui = gui;
    }


    public void run() {

	// Extract input files to inputFilesArray
	DefaultListModel files = (DefaultListModel) gui.volumesList.getModel();
	String [] inputFilesArray = new String [files.getSize()];
	for( int i = 0 ; i < files.size() ; i++ )
            inputFilesArray[i]=files.getElementAt(i).toString();

	// System.out.println(inputFilesArray);

	// Build command
	StringBuffer command = new StringBuffer();
	command.append("matlab ");
	command.append("-minimize -r \"");
	    

	if (!gui.maskTextField.getText().equals(""))
            command.append("vmask = lyngby_read_analyze('" 
			   + gui.maskTextField.getText()
			   + "', 'output', 'structure'); ");
             
	command.append("lyngby_batch_bmr({");

            
	for( int i = 0 ; i < files.size() ; i++ )
	    {
		command.append(inputFilesArray[i]);
		if (i<files.size()-1)
		    command.append("; ");
	    }
	command.append("}'");

	//Matlab script options

	//Lambda
	if (gui.lambdaCommonToSeriesAndMethods.isSelected())
	    command.append(",'lambdacommon', 'replicationsmethods'");
	else 
	    command.append(",'lambdacommon', 'replications'");
	        
	//Path
	command.append(",'path','"+gui.outputPathTF.getText()+"'");
	    
	//Prefix
	command.append(",'prefix','"+gui.outputPrefixTF.getText()+"'");
	    
	//VolMask
	if (!gui.maskTextField.getText().equals(""))
	    {
		command.append(",'VolMask', vmask");
	    }
	    
	//numberofthresholds
	command.append(",'numberofthresholds',"+gui.optionsThresholdTF.getText());
	    
	command.append(")\"");	    
	System.out.println(command.toString());

	run = new FisRunner(true, this, "lyngby_batch_bmr");
	run.runNewWithRedirect(command.toString(), true);

	run.pause();

      
	// check run status
      
	if (run.getExitValue() != 0) {
	    Dialogs.ShowErrorDialog(gui, "lyngby_batch_bmr program failed - Process message: "+run.getExitValue());
        } 
        else 
	    {
	        run.appendToRunWindow("lyngby_batch_bmr is done.");
	    }
        return;
    }
}

