// $Id: lyngby_batch_cc.java,v 1.1 2004/03/17 18:50:43 fnielsen Exp $

import java.io.*;
import fiswidgets.fisgui.*;
import fiswidgets.fisutils.*;

public class lyngby_batch_cc extends FisBase {
    // Default values
    String outputFilePathDefault;
    String inputFilePathDefault;
    String outputFilePrefixDefault;

    //Class variables
    FisProperties p1;

    //ImageIcon icon;

    //Series
    FisPanel seriesPanel;
    //    FisListBox volumesList;
    //    FisPanel buttonPanel;
    //    FisButton addButton;
    //    FisButton removeButton;
    //    FisAdvancedButton addButton2;
    //    FisButton okButton;
    //    FisFrame addDialogue2;
    //FisPanel dialoguePanel;
    // FisFileBrowser_edited inputFiles;
    FisFileBrowser inputFiles;
    FisListBox inputFilesList;
    FisLabel fileSelectionExplanation2;
    FisLabel fileSelectionExplanation1;
    
    //Mask file
    FisPanel maskPanel;
    FisTextField maskTextField;
    FisFileBrowser maskBrowser;

    //Paradigm file
    FisPanel paradigmPanel;
    FisTextField paradigmTextField;
    FisFileBrowser paradigmBrowser;
    
    
    //Options
    //FisPanel optionsPanel;
    //FisTextField optionsThresholdTF;
    //FisLabel optionsThresholdLabel;
    
    //Lambda
    //FisRadioButtonGroup lambdaChoices;
    //FisPanel lambdaPanel;
    //FisRadioButton lambdaCommonToSeriesAndMethods;
    //FisRadioButton lambdaCommonToSeries;

    //Output file options
    FisPanel outputPanel;
    FisLabel outputPrefixLabel;
    FisTextField outputPrefixTF;
    FisLabel outputPathLabel;
    FisTextField outputPathTF;
    FisFileBrowser outputPathBrowser;

    public lyngby_batch_cc()
    {
	///////////////// inherit Fisbase stuff
	super();

       ///////////////// Initialize variables
	int i;            // index variable
	String msg;       // buffer for error message in dialog box


       ///////////////// try loading .fisproperties file, check for browser, doc path - this will try and load the system default fisproperties.default or the .fisproperties of the user
	p1 = new FisProperties();
	try {
	    p1.loadFisProperties(FISPROPERTIES_SYSTEM_OR_USER);
	}
	catch (FisPropertyLoadException ex) {
	    Dialogs.ShowErrorDialog(this, "Property loading error:\n"+ex.getMessage());
	    System.exit(1);
	}

	// check for the properties this app needs: BROWSER and FISDOC_PATH
	String[] badprops = FisProperties.hasProperties(new String[] {"BROWSER", "FISDOC_PATH"});

	// If .fisproperties file is missing some properties we need
	if (badprops.length > 0) {
	    msg = new String("The following properties are not set in configuration file "+System.getProperty("user.home")+File.separator+FisProperties.FISPROPERTIESFILE+": ");

	    // list all the missing properties
	    for (i=0; i<badprops.length; i++)
		msg = msg.concat(badprops[i]+" ");
	    Dialogs.ShowErrorDialog(this, msg);
	    System.exit(1);
	}


	///////////////// load properties for this application
	//Properties appprop = new Properties();
	//try {
	//  FileInputStream fprop = new FileInputStream(".lyngby_properties");
	//    appprop.load(fprop);
	//    fprop.close();
	//} catch (IOException ex) {
	//   Dialogs.ShowErrorDialog(this, "Could not open tool properties:\n"+ex.getMessage());
	//}

       ///////////////// set run button, help button, about field
	lyngby_batch_cc_run run = new lyngby_batch_cc_run(this);
	activateRunButton(run, this);

       // activate the Help button by passing the html document for this help.
	try {
	    activateHelpButton("lyngby_batch_cc.html");
	}
	catch(FisHelpException ex){
	    Dialogs.ShowErrorDialog(this, "Help is not enabled, error:\n"+ex.getMessage());
	}

	///////////////// about box
	addToAbout("\nThe tool is part of the Lyngby Toolbox, a Matlab Toolbox for the analysis of functional neuroimages.\nCreated by Finn Nielsen and Thomas Kolenda, Technical University of Denmark, IMM.\n This particular script (lyngby_batch_cc.m) was wrapped in FisWidgets by Rasmus K Olsson.\n\nRead more at http://hendrix.imm.dtu.dk/software/lyngby/\n");

	///////////////// set title
	setTitle("Activity detection using cross-correlation - lyngby_batch_cc");

	//////////////// set logging
	setLogging(true);
	setLoggingFile("lyngby_batch_cc.log");

       ///////////////// set default values
       //outputFilePathDefault = appprop.getProperty("OUTPUT_PATH" , "./");
       //outputFilePrefixDefault = appprop.getProperty("OUTPUT_PREFIX" , "");
       //inputFilePathDefault = appprop.getProperty("INPUT_PATH" , "./");
	outputFilePathDefault = new String("./");
	outputFilePrefixDefault = new String("lyngby"); 
	inputFilePathDefault = new String("./");


	///////////////// set GUI widgets for this application

       //Icons
       //ImageIcon icon = new ImageIcon("logo3.gif");
       //addImageIcon("logo3.gif");
       //setIconImage(icon.getImage()); 

        //Summary image management
        seriesPanel = new FisPanel("Selection of images");
        addFisPanel(seriesPanel, 1, 1);
       
       
       //File selection window
       //addDialogue2 =new FisFrame();
       //addDialogue2.setTitle("Files selection");
       //fileSelectionExplanation1 = new FisLabel("Select summary images stemming from replications of", addDialogue2);
       //addDialogue2.newLine();
       //fileSelectionExplanation2 = new FisLabel("an activity detection experiment:", addDialogue2);
       //addDialogue2.newLine();
        inputFilesList = new FisListBox(300,seriesPanel);

        //dialoguePanel= new FisPanel();
        //addDialogue2.addFisPanel(dialoguePanel, 1, 1);
        
        //inputFiles = new FisFileBrowser_edited(inputFilePathDefault,new FisFileFilter("hdr"),seriesPanel);
        inputFiles = new FisFileBrowser(inputFilePathDefault,new FisFileFilter("hdr"),seriesPanel);
        //inputFiles.setMultiSelection(true);
        inputFiles.MultipleSelect=true;
        inputFiles.attachTo(inputFilesList);
        //dialoguePanel.newLine();
        //okButton = new FisButton("OK", dialoguePanel);
        //okButton.addActionListener(this);


        //volumesList = new FisListBox(400,seriesPanel);
        //seriesPanel.newLine();
        
        //buttonPanel = new FisPanel();
        //seriesPanel.addFisPanel(buttonPanel, 1, 1);
        //addButton2 = new FisAdvancedButton("Add replications",buttonPanel, addDialogue2);

        //removeButton = new FisButton("Remove all", buttonPanel);
        //removeButton.addActionListener(this);

        addBreakLine();

        //options
        //optionsPanel = new FisPanel("Algorithm options");
        //addFisPanel(optionsPanel, 1, 1);
        
        //lambda
        //lambdaPanel = new FisPanel("Generality of lambda");
        //optionsPanel.addFisPanel(lambdaPanel, 1, 1);

        //lambdaCommonToSeriesAndMethods = new FisRadioButton("Common to replications", true, lambdaPanel);
        //lambdaPanel.newLine();
        //lambdaCommonToSeries = new FisRadioButton("Common to replications and methods", false, lambdaPanel);

        //lambdaChoices = new     FisRadioButtonGroup();
        //lambdaChoices.add(lambdaCommonToSeriesAndMethods);
        //lambdaChoices.add(lambdaCommonToSeries);
        
        //optionsThresholdLabel = new FisLabel("Thresholding levels", optionsPanel);
        //optionsThresholdTF = new FisTextField("8",optionsPanel);
        //optionsThresholdTF.setQuarterWidth();
        //optionsThresholdTF.setHorizontalAlignment(JTextField.RIGHT);
        
        //addBreakLine();

        //Mask file management
        maskPanel = new FisPanel("Selection of mask file");
        addFisPanel(maskPanel, 1, 1);
        maskTextField=new FisTextField(maskPanel);
        maskBrowser = new FisFileBrowser(inputFilePathDefault, new FisFileFilter("hdr"),maskPanel);
        maskBrowser.MultipleSelect=false;
        maskBrowser.attachTo(maskTextField);
        addBreakLine();

        //Paradigm file management
        paradigmPanel = new FisPanel("Selection of paradigm file");
        addFisPanel(paradigmPanel, 1, 1);
        paradigmTextField=new FisTextField(paradigmPanel);
        paradigmBrowser = new FisFileBrowser(inputFilePathDefault, paradigmPanel);
        paradigmBrowser.MultipleSelect=false;
        paradigmBrowser.attachTo(paradigmTextField);
        addBreakLine();
        
        //output
        outputPanel = new FisPanel("Output file options");
        addFisPanel(outputPanel, 1, 1);
        outputPrefixLabel = new FisLabel("Prefix",outputPanel);
        outputPrefixTF = new FisTextField(outputFilePrefixDefault,outputPanel);
        outputPanel.newLine();
        outputPathLabel = new FisLabel("Path",outputPanel);
        outputPathTF = new FisTextField(outputFilePathDefault,outputPanel);
        outputPathBrowser = new FisFileBrowser(inputFilePathDefault, outputPanel);
        outputPathBrowser.DirectoriesOnly=true;
        outputPathBrowser.attachTo(outputPathTF);


	display();

    }


    // standard main function, unchanged for all FisBase classes
    public static void main(String[] args) {
	lyngby_batch_cc wt = new lyngby_batch_cc();
    }
}

