// $Id: lyngby_batch_cc_run.java,v 1.1 2004/03/17 18:49:24 fnielsen Exp $

import fiswidgets.fisgui.*;
import fiswidgets.fisutils.*;
import javax.swing.*;


public class lyngby_batch_cc_run extends FisRunManager {
    lyngby_batch_cc gui;
    FisRunner run;
    
    public lyngby_batch_cc_run(lyngby_batch_cc gui) {
	super();
	this.gui = gui;
    }

    public void run() {

	// Extract input files to inputFilesArray
	DefaultListModel files = (DefaultListModel) gui.inputFilesList.getModel();
	String [] inputFilesArray = new String [files.getSize()];
	for( int i = 0 ; i < files.size() ; i++ )
            inputFilesArray[i]=files.getElementAt(i).toString();
	
	System.out.println(inputFilesArray);
	
	// Build command
	StringBuffer command = new StringBuffer();
	command.append("matlab ");
	command.append("-minimize -nosplash -r \"");
	
	if (!gui.maskTextField.getText().equals(""))
            command.append("vmask = lyngby_read_analyze('" 
			   + gui.maskTextField.getText()
			   + "', 'output', 'structure'); ");
             
	command.append("lyngby_batch_cc({");
	
	for ( int i = 0 ; i < files.size() ; i++ ) {
	    command.append("'");
	    command.append(inputFilesArray[i]);
	    command.append("'");
	    if (i<files.size()-1)
		command.append(", ");
	}
	command.append("}");
	
	// Matlab script options

	// Paradigm
	command.append(", '"+gui.paradigmTextField.getText()+"'");
	    
	// Path
	command.append(",'path','"+gui.outputPathTF.getText()+"'");
	    
	// Prefix
	command.append(",'prefix','"+gui.outputPrefixTF.getText()+"'");
	    
	// VolMask
	if (!gui.maskTextField.getText().equals("")) {
    	    command.append(",'VolMask', vmask");
	}
	    
	command.append(")\"");	    
	System.out.println(command.toString());

	run = new FisRunner(true, this, "lyngby_batch_cc");
	run.runNewWithRedirect(command.toString(), true);
	
	run.pause();
	
      
	// check run status
	
	if (run.getExitValue() != 0) {
	    Dialogs.ShowErrorDialog(gui, "lyngby_batch_cc program failed - Process message: " 
				    + run.getExitValue());
        } 
        else {
	    run.appendToRunWindow("lyngby_batch_cc is done.");
	}
        return;
    }
}












