// lyngby_batch_cons.java
// 
// $Id: lyngby_batch_cons.java,v 1.1 2004/03/11 16:57:25 fnielsen Exp $

import java.io.*;
import java.util.*;
import fiswidgets.fisgui.*;
import fiswidgets.fisutils.*;



public class lyngby_batch_cons extends FisBase 
{
    // Default values	
    String outputFilePathDefault;
    String inputFilePathDefault;
    String outputFilePrefixDefault;

    // Class variables
    FisProperties p1;
    FisFileChooser inputFiles;
    FisTextField outputFilePrefix;
    FisTextField outputFilePath;
    FisListBox inputFilesList;
    FisCheckBox DoHistEqOn;


    public lyngby_batch_cons()
    {

       ///////////////// inherit Fisbase stuff
       super();

       ///////////////// Initialize variables
       int i;            // index variable
       String msg;       // buffer for error message in dialog box


       ///////////////// try loading .fisproperties file, check for browser, doc path - this will try and load the system default fisproperties.default or the .fisproperties of the user
       p1 = new FisProperties();
       try {
	       p1.loadFisProperties(FISPROPERTIES_SYSTEM_OR_USER);
       }
       catch (FisPropertyLoadException ex) {
         Dialogs.ShowErrorDialog(this, "Property loading error:\n"+ex.getMessage());
         System.exit(1);
       }

       // check for the properties this app needs: BROWSER and FISDOC_PATH
       String[] badprops = FisProperties.hasProperties(new String[] {"BROWSER", "FISDOC_PATH"});

       // If .fisproperties file is missing some properties we need
       if (badprops.length > 0) {
         msg = new String("The following properties are not set in configuration file "+System.getProperty("user.home")+File.separator+FisProperties.FISPROPERTIESFILE+": ");

         // list all the missing properties
         for (i=0; i<badprops.length; i++)
             msg = msg.concat(badprops[i]+" ");
         Dialogs.ShowErrorDialog(this, msg);
         System.exit(1);
       }


       ///////////////// load properties for this application 
       Properties appprop = new Properties();
       // try {
       //  FileInputStream fprop = new FileInputStream(".lyngby_properties");
       //	       appprop.load(fprop);
       //	       fprop.close();
       //      } catch (IOException ex) {
       //         Dialogs.ShowErrorDialog(this, "Could not open tool properties:\n"+ex.getMessage());
       //     }

       ///////////////// set default values
       outputFilePathDefault = appprop.getProperty("GUI_DEFAULTS" , "./");
       outputFilePrefixDefault = appprop.getProperty("OUTPUT_PREFIX" , "lyngby");
       inputFilePathDefault = appprop.getProperty("GUI_DEFAULTS" , "./");



       ///////////////// set run button, help button, about field
       lyngby_batch_cons_run run = new lyngby_batch_cons_run(this);
       activateRunButton(run, this);

       // activate the Help button by passing the html document for this help.
       try {
      	  activateHelpButton("lyngby_batch_cons.html");
       }
       catch(FisHelpException ex){
          Dialogs.ShowErrorDialog(this, "Help is not enabled, error:\n"+ex.getMessage());
       }

       ///////////////// about box
       addToAbout("\nThe tool is part of the Lyngby Toolbox, a Matlab Toolbox for the analysis of functional neuroimages, Technical University of Denmark.\n\nRead more at http://hendrix.imm.dtu.dk/software/lyngby/\n");
       
       ///////////////// set title  
       setTitle("Batch for consensus modeling - lyngby_batch_cons");

       //////////////// set logging
       setLogging(true);
       setLoggingFile("lyngby_batch_cons.log");
       


       
       ///////////////// set GUI widgets for this application 
     	 FisPanel panel0 = new FisPanel();
    	 addFisPanel(panel0,1,1);

   		 FisLabel Lbl1 = new FisLabel("Input file(s) (analyze format):",panel0);
		   panel0.newLine();     

       inputFilesList = new FisListBox(400,panel0);      		 
       inputFilesList.setToolTipText("Lists the input files. Press [Browse] and [<<] buttons to specify files");
		   panel0.newLine(); 
		   
   		 inputFiles = new FisFileChooser(inputFilePathDefault,new FisFileFilter("hdr"),panel0);
       inputFiles.attachTo(inputFilesList);
       inputFiles.setToolTipText("Choose the input files that should be run");
   		 inputFiles.getMultiSelection(); 
       inputFiles.setExpanded(true); 

    	 this.addBlank();
    	 this.newLine();
    	
    	 FisPanel panel1 = new FisPanel();
    	 addFisPanel(panel1,1,1);
    	 
       panel1.newLine();
       DoHistEqOn = new FisCheckBox("Do histogram equalization", true, panel1);
       DoHistEqOn.setToolTipText("Do histogram equalization");

       panel1.newLine();       
       outputFilePath = new FisTextField("Path where output files are stored:", outputFilePathDefault, panel1);
       outputFilePath.setToolTipText("Path where output files are stored, e.g. ./data/");

       panel1.newLine();       
       outputFilePrefix = new FisTextField("Prefix of output file:", outputFilePrefixDefault, panel1);
	     outputFilePrefix.setToolTipText("Add prefix text to output files, e.g. MyRun_");
	
	panel1.addBlank();
    	 panel1.addBlank();
    	  
       display();

   }


   // standard main function, unchanged for all FisBase classes
   public static void main(String[] args) {
      lyngby_batch_cons wt = new lyngby_batch_cons();
   }

}

