// $Id: lyngby_batch_cons_run.java,v 1.1 2004/03/11 17:00:10 fnielsen Exp $

import java.io.*;
import java.lang.*;
import fiswidgets.fisgui.*;
import fiswidgets.fisutils.*;
import javax.swing.*;

public class lyngby_batch_cons_run extends FisRunManager
{
   lyngby_batch_cons gui;         
   FisRunner run;      

   final String matlabCommand = "lyngby_batch_cons";


   public lyngby_batch_cons_run(lyngby_batch_cons gui)
   {
      super();
      this.gui = gui;
   }


   public void run() {

      // Path to output files
      String outputFilePath = gui.outputFilePath.getText();

      // Output prefix string 
      String outputFilePrefix = gui.outputFilePrefix.getText();

      // Extract input files to inputFilesArray
		  DefaultListModel files = (DefaultListModel) gui.inputFilesList.getModel();
		  String [] inputFilesArray = new String [files.getSize()]; 
		  for( int i = 0 ; i < files.size() ; i++ )
	    	inputFilesArray[i]=files.getElementAt(i).toString();

      // Do histogram equalization
      boolean DoHistEqOn = gui.DoHistEqOn.isChecked();
      String DoHistEqOnStr;

     
      // Build command
	    StringBuffer command = new StringBuffer();
	    command.append("matlab ");
      command.append("-nodesktop ");	      
	    
	    command.append("-r \"");
	    command.append(matlabCommand);
	    command.append("( { ");

		  for( int i = 0 ; i < files.size() ; i++ ) {
  	    command.append("'");
  	    command.append(inputFilesArray[i]);
  	    command.append("' ");	    	    		     
		  }

	    command.append("} , 'prefix' , '");
	    command.append(outputFilePrefix);	    
	    command.append("' , 'path' , '");
	    command.append(outputFilePath);
	    command.append("' , 'Scaling' , '");
	    if (DoHistEqOn==true) {
	      DoHistEqOnStr = "HistEq";
	    } else {
	      DoHistEqOnStr = "none";
	    }
      command.append(DoHistEqOnStr);
	    command.append("') ");	    
	    command.append(",exit\"");
	    
	    System.out.println(command.toString());
      
	    run = new FisRunner(true, this, "lyngby_batch_cons");
	    run.runNewWithRedirect(command.toString(), true);    
	    run.pause();		        

      // check run status
      if (run.getExitValue() != 0) {
          Dialogs.ShowErrorDialog(gui, "lyngby_batch_cons program failed - Process message: "+run.getExitValue());
      } else {
	    	  run.appendToRunWindow("lyngby_batch_cons is done.");
		  }

      return;
   }  
   
                
}

