function t = lyngby_bat_test(P, X, arg1, arg2, arg3, arg4, arg5, arg6, ...
    arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15) 

% lyngby_bat_test      - t-test using the Ardekani t-method
%
%       function t = lyngby_bat_test(P, X, PropertyName, PropertyValue)
%
%       Input:    P      Normalized paradigm (no mean)
%                 X      Normalized datamatrix
%
%       Property: Delay  { 0 } Delay, Number of timesteps the
%                        paradigm will be moved with reference to
%                        the datamatrix.
%
%       Output:   t      t-statstics value.
%
%       This function will return the t-statistics measure using  
%                (P' * X) / (sigma_est * sqrt(P' * P))
%
%       See also LYNGBY, LYNGBY_BAF_TEST, LYNGBY_BAF2_TEST.
%
% $Id: lyngby_bat_test.m,v 1.7 2002/11/18 17:48:15 fnielsen Exp $

    % Sizes
    [rX, cX] = size(X);
    [rP, cP] = size(P);
    
    % Check arguments
    if rX ~= rP
      error('P and X should have the same number of rows');
    end
    
    % Default values
    delay = 0;

    % Parse Properties
    n = 1;
    while n < nargin-1
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'delay')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	delay = arg;
	if delay<0 
	  error('The delay should be non-negative')
	end
      else
	error('Invalid property');
      end
      n = n + 1;
    end

    denom = P'*P;
    SP = P*P'/denom;
    sqrtdenom = sqrt(denom);

    reloneminusSP = (eye(size(SP))-SP)/(rX-2);

    t = zeros(1,cX);

    tPr = (P(1:rX-delay))';

    for v = 1:cX,
      if lyngby_mod(v,100)==0,
	lyngby_log(sprintf('Computing t-map %i / %i', v, ...
	    cX));
      end;
      
      y = X(1:rX,v);

      if (std(y)<1e-9)
	t(1,v) = 0;
      else
	yr = y(1+delay:rX);
	sigma = sqrt(y'*reloneminusSP*y);
	t(1,v) = (tPr*yr)/(sigma*sqrtdenom);
      end
    end

    lyngby_log(sprintf('Done Computing t-map '));
















