function lyngby_batch_prep(filenames, varargin)

% lyngby_batch_prep    - Batch preprocessing
%
%       lyngby_batch_prep(filenames, 'PropertyNames',
%           'PropertyValues') 
% 
%       Input:    Filenames  Volume filenames (ANALYZE)
%
%       Property: Type       [ {linear} ]
%
%       Preprocess data. 
%
%       See also LYNGBY, LYNGBY_READ_VOLUMES.
%
% $Id: lyngby_batch_prep.m,v 1.2 2003/05/22 15:27:28 fnielsen Exp $      


    % Default properties
    type            = 'linear'; 
    filenameMask    = '';
    filenamesOutput = [];
    Vmask           = []; 
    
    
    % Read properties
    for n = 1:2:length(varargin)
      arg = lower(varargin{n});

      if strcmp(arg, 'filenamemask') 
      	arg = varargin{n+1};
	if isstr(arg) 
	  filenameMask = arg;
	else
	  error('Argument with ''FilenameMask'' should be a string');
	end

      elseif strcmp(arg, 'volmask') 
      	arg = varargin{n+1};
	if isstruct(arg) 
	  Vmask = arg;
	else
	  error('Argument with ''VolMask'' should be a structure');
	end
	
      else
	error(sprintf('Invalid property: %s', arg));
      end
    end

    
    % Read volumes
    X = lyngby_read_volumes(filenames, 'FilenameMask', filenameMask, ...
	'VolMask', Vmask); 


    XN = X; 
    
    % Preprocess
    if strcmp(type, 'linear')
      % Linear, ie, first order. 
      
      XN.matrix = lyngby_prep_detrend(X.matrix, 'order', 1);
    
    else
      error('Internal error (type)');
    end


    if isempty(filenamesOutput)
      for n = 1:length(filenames)
	filenamesOutput{n} = [ 'p' filenames{n} ];
      end
    end

    XN.rows = filenamesOutput;
    
 
    lyngby_write_volumes(XN, 'VolMask', Vmask, 'datatype', 'int16');

