function P = lyngby_cdf_beta(x, a, b)

% lyngby_cdf_beta      - Beta cumulative probability function
%
%       function P = lyngby_cdf_beta(x, a, b)
%
%       Input:  x   Data point 
%               a   first parameter
%               b   second parameter
%
%       Output: p   Beta probability density function
%
%       The beta cumulative probability function is defined as
% 
%       P(x) = I(x,a,b)
%
%       That is the incomplete beta function
%
%       See also LYNGBY, LYNGBY_CDF_CHI2, LYNGBY_CDF_F,
%                LYNGBY_CDF_FISHERSG, LYNGBY_CDF_GAUSS,
%                LYNGBY_CDF_T, LYNGBY_CDF_WILRANK, LYNGBY_IDF_BETA,
%                LYNGBY_PDF_BETA, LYNGBY_PDF_GAUSS.
%
% $Id: lyngby_cdf_beta.m,v 1.2 2003/02/11 19:53:50 fnielsen Exp $



    P = betainc(x,a,b);
