function P = lyngby_cdf_bin(X, n, p)

% lyngby_cdf_bin       - Binomial distribution function
%
%       function P = lyngby_cdf_bin(X, n, p)
%
%       Input:  X        Data point
%               n        "Number of coin flips"
%               p        probability, "Irregularity of coin"
%
%       Output: P        Binomial distribution function
%
%       See also: lyngby_pdf_bin, lyngby_cdf_gauss

% cvs:  $Id: lyngby_cdf_bin.m,v 1.1 1999/01/12 17:25:22 fnielsen Exp $
%       $Revision: 1.1 $


    P = 0;
    for x = 0:X
      P = P + nchoosek(n,x) * p^x * (1-p)^(n-x);
    end


