function F = lyngby_cdf_gauss(x, my, sigma)

% lyngby_cdf_gauss     - Gaussian (normal) distribution function
%
%       function F = lyngby_cdf_gauss(x)
%
%       Input:  x       
%               my      Mean (optional, default 0)
%               sigma   Variance (optional, default 1)
%
%       Output: F       Lower tail area
%
%       Lower tail area of the Gaussian probability density function. 
%
%       Ref: Lennart Raade, Beta 17.4, page 385, 1990
%
%       See also LYNGBY, LYNGBY_CDF_BETA, LYNGBY_CDF_CHI2,
%                LYNGBY_CDF_F, LYNGBY_CDF_FISHERSG, LYNGBY_CDF_T,
%                LYNGBY_CDF_WILRANK. 
%
% $Id: lyngby_cdf_gauss.m,v 1.2 2003/02/11 19:54:05 fnielsen Exp $


    % Default parameters
    if nargin < 3
      sigma = 1;
      if nargin < 2
	my = 0;
      end
    end

    if nargin > 1
      x = (x - my) / sqrt(sigma);
    end

    if x <= 0
      p = x * (1.5976 + 0.070566*x.^2);
      F = 1/( 1 + exp(-p) );
    else
      p = - x * (1.5976 + 0.070566*x.^2);
      F = 1 - 1/( 1 + exp(-p) );
    end
    
    p = x * (1.5976 + 0.070566*x.^2);
    F = 1/( 1 + exp(-p) );

















