function [c,C] = lyngby_classerr(T, Y, cut)

% lyngby_classerr      - Classification error
%
%	function [c,C] = classerr(T, Y, cut)
%
%	Input:	T	Target output
%		Y	Model output
%		cut	Classification threshold 
%                       (optional, default = 0)
%
%	Output:	c	Classification error in percentice
%		C	Confusion matrix, O indices columns, D rows
%
%       If T and Y has one column each it is assumed that the the
%       first class is indicated by being smaller than "cut" and the
%       second class is indicated by begin larger.
%
%       If T and Y has more than one column then the largest value in
%       each the column will be considered to indicate the class and
%       compared to T. The values of T is assumed to be either 0 or 1.

% cvs : $Id: lyngby_classerr.m,v 1.1 1998/03/20 14:15:57 fnielsen Exp $
%       $Revision: 1.1 $

    if exist('cut') ~= 1
      cut = 0;
    end
    
    [Np, No] = size(T);
    
    if No == 1
      C(1,1) = prod(size(find(T>cut & Y>cut)));
      C(2,2) = prod(size(find(T<cut & Y<cut)));
      C(1,2) = prod(size(find(T>cut & Y<cut)));
      C(2,1) = prod(size(find(T<cut & Y>cut)));
    
      c = (C(2,1) + C(1,2)) / Np;
    else

      W = zeros(size(Y'));
      [Max, I] = max(Y');
      I = I + (0:No:((Np-1)*No));
      W(I) = 1;
      
      C = W *T;
      c = 1 - sum(diag(C)) / sum(sum(C));
      
    end

	










