function Rhoc = lyngby_corrlin(X)

% lyngby_corrlin		- Lin's concordance correlation coefficient for reproducibility
%
%	function Rhoc = lyngby_corrlin(X)
%
%	Input:	X:	Coloum vectors to be compared
%
%	Output:	Rhoc:	The concordance Matrix
%
%	Ref:	Lin:	Biometrics 1989.45

%	1996-02-06	fnielsen	Initial version
%	1997-01-30	fnielsen	femarized

% cvs :  $Revision: 1.2 $

	[Nx,Np] = size(X);

	Rhoc = 0.5 * eye(Np);

	for p1 = 1:Np-1

		my1 	= mean(X(:,p1));
		sigma1	= std(X(:,p1));

		for p2 = p1+1:Np
			
			my2 	= mean(X(:,p2));
			sigma2	= std(X(:,p2));

			sigma12 = cov([ X(:,p1) X(:,p2)]);
			Rhoc(p1,p2) = 2 * sigma12(1,2)  / (sigma1^2 + sigma2^2 + (my1-my2)^2 );


		end
	end

	Rhoc = Rhoc + Rhoc';

