function Y = lyngby_cumperiodo(X)

% lyngby_cumperiodo    - Normalized cumulated periodogram
%
%       function Y = lyngby_cumperiodo(X)
%
%	Input:	X   Time domain input (of residual)
%
%	Output:	Y   Cumulated frequency domain

% cvs : $Id: lyngby_cumperiodo.m,v 1.1 1998/03/03 12:38:21 fnielsen Exp $
%       $Revision: 1.1 $


    [rX, cX] = size(X);
    index = 1:round(rX/2);
    I = abs(fft(X));
    
    Y = cumsum(I(index,:)) ./ sum(I(index,:) + realmin);
