function bits = lyngby_datatype2bit(s)

% lyngby_datatype2bit  - Return number of bits for datatype
%
%       function bits = lyngby_datatype2bit(s) 
%
%       Input:  s     String
% 
%       Output: bits  Bits for the datatype

% cvs : $Id: lyngby_datatype2bit.m,v 1.1 1999/07/09 14:56:16 fnielsen Exp $
%       $Revision: 1.1 $

    switch s
    case {'uchar', 'schar', 'int8', 'uint8', 'char'}    
      bits = 8;
    case {'int16', 'uint16', 'short', 'ushort'}
      bits = 16;
    case {'int32', 'uint32', 'single', 'float32', 'int', 'uint', 'float'} 
      bits = 32;
    case {'int64', 'uint64', 'double', 'float64'}
      bits = 64;
    case {'long', 'ulong'}   
      % 32 bits or 64 bits.
      bits = 64;
    otherwise
      if strncmp(s, 'bit', 3)
	bits = str2num(s(4:end));
      elseif strncmp(s, 'ubit', 4)
	bits = str2num(s(4:end));
      else
	error('Unrecognized datatype')
      end
    end
      

