function [Y,meanY,stdY] = lyngby_normalize(X, arg1, arg2, arg3, arg4);

% lyngby_normalize	- Normalize in vertical direction of a datamatrix
%
%	function Y = lyngby_normalize(X, arg1, arg2, arg3, arg4);
%
%	Input:	X	A datamatrix
%		PropertyNames:
%			'Centering'		[ {1} | 0 ] Extract the mean
%			'Normalization'		[ {1} | 0 ] Divide by the standard deviation 
%	
%	Output:	Y	The output matrix
%               meanY   The mean values in each voxel
%               stdY    The standard deviation in each voxel

%	Date		Author		Version
%	1996-09-16	fnielsen	Initial Version
%	1996-09-18	Peter Toft	Include mean and std var in return val
%	1996-11-28	fnielsen	'Centering' and 'Normalization' implemented

% cvs :  $Revision: 1.1.1.1 $

	bCentering = 1;
	bNormalization = 1;

	n = 1;
	while n < nargin
		eval(sprintf('arg = lower(arg%d);', n)); 
		if strcmp(arg, 'centering')
			n = n + 1;
			eval(sprintf('arg = arg%d;', n));
			if arg == 1 | arg == 0
				bCentering = arg;
			else
				error(sprintf('Type ''%s'' not recognized', arg));
			end
		elseif strcmp(arg, 'normalization')
			n = n + 1;
			eval(sprintf('arg = arg%d;', n));
			if arg == 1 | arg == 0
				bNormalization = arg;
			else
				error(sprintf('Type ''%s'' not recognized', arg));
			end
		else
			error('Invalid property');
		end
		n = n + 1;
	end



        meanY = mean(X);
        stdY = std(X);
	if bCentering
		X = X -  (ones(size(X,1),1) * meanY);
	end
	if bNormalization
		X = X ./ (ones(size(X,1),1) * stdY+realmin);
	end
	Y = X;














