function I = lyngby_dropedge(P, onDrop, offDrop)

% lyngby_dropedge      - Drop scans at the paradigm shifts
%
%       function I = lyngby_dropedge(P, onDrop, offDrop)
%
%       Input:  P         Paradigm (column vector)
%               onDrop    Scans to drop at the rise flange
%               offDrop   Scans to drop at the fall flange
%
%       Scans at the very start is not dropped.
%
%       Output: I         Indices for remaining ("un-dropped") scans

% cvs : $Id: lyngby_dropedge.m,v 1.2 1997/09/09 15:20:02 fnielsen Exp $
%       $Revision: 1.2 $


   onEdge = find(diff(P) > 0);
   offEdge = find(diff(P) < 0);

   onIndex = (1:onDrop)';
   offIndex = (1:offDrop)';
   
   onDropIndex = lyngby_kronadd(onEdge, onIndex);
   offDropIndex = lyngby_kronadd(offEdge, offIndex);

   I = lyngby_set_diff(1:length(P), [onDropIndex ; offDropIndex]);



