function pos = lyngby_filefind(filename, str)

% lyngby_filefind  - Find the position of a string in a file
%
%       pos = lyngby_filefind(filename, str)     
%
%       Input:  filename   File to be search
%               str        String to be found
%
%       Output: pos        Position of first instance of str, 
%                          return 0 if not found

%       From Egill Rostrup

%       $Id: lyngby_filefind.m,v 1.3 1997/07/22 17:53:56 fnielsen Exp $
%       $Revision: 1.3 $


    if ~exist(filename)
      error(sprintf('File %s not found\n', fname));
    end

    fid = fopen(filename, 'r');

    slen = size(str,1);

    blocksize = 32000;
    offset = 0;
    p = 0;

    while 1
      fseek(fid, offset, -1);
      [fstr, c] = fread(fid, blocksize, 'char');
      if c == 0
	break 
      end
      p = findstr(fstr', str);
      if ~isempty(p)
	break
      end
      offset = offset + blocksize - slen;
    end
    
    if isempty(p)
      pos = 0;
    else
      pos = p(1) + offset;
    end


    fclose(fid);




