function Y = lyngby_fir_convolve(x, Param)

% lyngby_fir_convolve  - Convolve the FIR kernel with the input
%
%       function Y = lyngby_fir_convolve(X, Param)
%
%       Input:  x       The input (usually the paradigm), 
%               Param   FIR kernel coefficients
%
%       Output: Y       Convolved output (time domain)
%
%       This functions convolve the input in x with the FIR kernel in
%       Param. The 'conv' function is used for this.
%
%       See also LYNGBY, LYNGBY_FIR_MAIN. 
%
% $Id: lyngby_fir_convolve.m,v 1.10 2001/06/06 18:39:34 fnielsen Exp $


    
    [nScans, dummy] = size(x);
    [dummy, nVoxels] = size(Param);
  
    Y = zeros(nScans, nVoxels);
    
    if 0
      % Memory consuming and perhaps slow:
      % Iterate over the coefficients

      for t = 1:size(Param, 1),
	convsize = nScans - t + 1;
	Y(t:nScans,:) = Y(t:nScans,:) + (X(1:convsize,1) * ...
	    ones(1,voxels)) .* (ones(convsize,1) * Param(t,:));
      end
      
    else
      % Seems to be relatively fast:
      % Iterate over voxels

      for v = 1:nVoxels

	y = conv(x, Param(:,v)); 
	Y(:,v) = y(1:nScans);
      
      	if ~lyngby_mod(v, 100) 
	  lyngby_log(sprintf('Convolving: %d / %d', v, nVoxels));
	end
      end
      lyngby_log(sprintf('Convolving: %d / %d', v, nVoxels));
    
    end




















