function [E, EY] = lyngby_fir_error(T, Y)	
	
% lyngby_fir_error     - FIR residual signal (Quadratic error)
%
%       function [E, EY] = lyngby_fir_error(T, Y)	
%
%       Input:  T    Target output
%               Y    Firson filter prediction
%
%       Output: EY   Error matrix for output units (T-Y)
%               E    Qudratic error, normalized for the number of
%                    examples
%
%       The function computes this:   1/(Np) * (sum( (T-Y).^2 ))
%
%       If T has more rows than Y it will only use the last samples of
%       T in the subtraction with Y.
%
%       T and Y can be vectors or matrices.
%
%       See also: LYNGBY_FIR_MAIN

% cvs : $Id: lyngby_fir_error.m,v 1.2 2000/05/03 15:39:36 fnielsen Exp $
%       $Revision: 1.2 $

    [rT, cT] = size(T);
    [rY, cY] = size(Y);

    if rT > rY
      if cT == cY 
	EY = T((rT-rY+1):rT,:) - Y;
      elseif cT == 1
	EY = T((rT-rY+1):rT,ones(cY,1)) - Y;
      elseif cY == 1
      	EY = T((rT-rY+1):rT,:) - Y(:,ones(cT,1));
      else
	error('Wrong size ')
      end
    elseif rT == rY
      if cT == cY 
	EY = T - Y;
      elseif cT == 1
	EY = T(:,ones(cY,1)) - Y;
      elseif cY == 1
      	EY = T - Y(:,ones(cT,1));
      else
	error('Wrong size ')
      end
    else
      error('Wrong size ')
    end
      
    E  = 1/rY * sum(EY.^2);
















