function lyngby_fir_init

% lyngby_fir_init      - Initialize global variables for FIR analysis
%
%       function lyngby_fir_init
%
%       Global: FIR_ORDER            Lag of model sat to 7. 
%               FIR_REGULARIZATION   Ridge regression/SVD threshold ...
%	                             parameter sat to 1.
%               FIR_REGMETHOD        Regularization method sat to
%                                    ordinary regularized inversion. 
%               FIR_CONVTYPE         Skipping first FIR_ORDER-1 of
%                                    samples in the fitting: 'Skip'
%
%       See also LYNGBY, LYNGBY_FIR_GLOBAL, LYNGBY_FIR_MAIN,
%                LYNGBY_UI_FIR_INIT. 
%
% $Id: lyngby_fir_init.m,v 1.7 2001/06/06 18:40:53 fnielsen Exp $


    lyngby_fir_global

    FIR_ORDER = 7;
    FIR_REGULARIZATION = 1;
    FIR_REGMETHOD = 'RegInverse';
    FIR_CONVTYPE = 'Skip';
    FIR_PCRCOMP = 3;
