function M = lyngby_fir_masscent(result_fir, arg1);

% lyngby_masscenter	- Returns the masscenter of the FIR kernel
%
%	function M = lyngby_fir_masscent(result_fir, type);
%	function M = lyngby_fir_masscent(result_fir);
%
%	Input:	result_fir	Result from the FIR analysis
%		type		[ {none} | absabs | abs | discard ] 
%		                Type of mass center 
%
%	Output:	M		mass center
%
%	The FIR coefficients can be negative. The 'type' controls
%	how these negative coefficients should be treated.
%		M = sum(|n*h(n)|) / sum(|h(n)|)
%	The 'absabs' is the upper formula. 
%	With 'abs' the nominator || function is discarded. 
%	With 'none' no absolute value is taken. This is the default
%	With 'discard' the negative numbers are put to zero.
%	The weights are index from 0.
%
%	See also LYNGBY, LYNGBY_FIR_MAIN.
%
% $Id: lyngby_fir_masscent.m,v 1.2 2004/06/01 12:25:55 fnielsen Exp $

	centerType = 4;

	n = 1;
	while n < nargin
		eval(sprintf('arg = lower(arg%d);', n)); 
		if strcmp(arg, 'absabs')
			centerType = 1;
		elseif strcmp(arg, 'abs')
			centerType = 2;
		elseif strcmp(arg, 'discard')
			centerType = 3;
		elseif strcmp(arg, 'none')
			centerType = 4;
		end
		n = n + 1;
	end

	[lag,voxels] = size(result_fir);
	t = (0:lag-1)';
	if centerType == 1
		M = sum(abs(result_fir .* (t*ones(1,voxels)))) ./ (realmin + sum(abs(result_fir)));
	elseif centerType == 2
		M = sum(result_fir .* (t*ones(1,voxels))) ./ (realmin + sum(abs(result_fir)));
	elseif centerType == 3
		indices = find(result_fir<0);
		result_fir(indices) = zeros(length(indices),1);
		M = sum(result_fir .* (t*ones(1,voxels))) ./ (realmin + sum(abs(result_fir)));
	elseif centerType == 4
		M = sum(result_fir .* (t*ones(1,voxels))) ./ (realmin + sum(result_fir));
	end








