function X = lyngby_fir_paradigm2design(x, filterOrder); 

% lyngby_fir_paradigm2design - Paradigm vector to design matrix
%
%       X = lyngby_fir_paradigm2design(x)
%
%       Input:  x            Paradigm vector
%               filterOrder  Number of stick functions
% 
%       Output: X            Design matrix
%
%       Converts a paradigm vector to a design matrix. 
%
%       Zeropadding is used for the first unknown part of the design
%       matrix.  
%
%       See also LYNGBY, LYNGBY_FIR_MAIN, LYNGBY_FIR_TEST_CHI2. 
%
% $Id: lyngby_fir_paradigm2design.m,v 1.1 2003/02/18 20:15:19 fnielsen Exp $


    % Check input arguments
    if nargin < 2
      error('Too few input arguments')
    end


    N = length(x);
    X = zeros(N, filterOrder);     % The Input as a matrix
    x2 = [ zeros(filterOrder-1,1); x ];
    for n = 1:N,
      X(n,:) = x2(filterOrder+n-1:-1:n)';
    end
