function indexInMask = lyngby_full2mask(indexInFull);

% lyngby_full2mask     - Convert indices from Full volume to ROI volume
%
%       function indexInMask = lyngby_full2mask(indexInFull);
%
%       Input:  indexInFull   Scalar index in Full Volume or 3 element
%                             vector with x,y,z index in full volume
%
%       Output: indexInMask   Scalar index in ROI volume. An empty
%                             matrix is returned if the index is not
%                             in the ROI or is not within the VOXEL_MASK
%
%       See also: lyngby_mask2full, lyngby_index2vmask,
%                 lyngby_vmask2index, lyngby_roi

% cvs : $Id: lyngby_full2mask.m,v 1.3 1998/03/27 17:55:09 fnielsen Exp $
%       $Revision: 1.3 $

    lyngby_global

    if length(indexInFull) == 3
      indexInFull = indexInFull(1) + (indexInFull(2)-1) * NUM_VOXELS(1) + ...
	  (indexInFull(3)-1) * NUM_VOXELS(1) * NUM_VOXELS(2);
    end
    
    ROI = lyngby_roi;
    
    x = ROI(1,1):ROI(1,2);
    y = ROI(2,1):ROI(2,2);
    z = ROI(3,1):ROI(3,2);
    yy = NUM_VOXELS(1)*(y-1);
    zz = prod(NUM_VOXELS(1:2))*(z-1);
    xy = kron(ones(size(y)),x)+kron(yy,ones(size(x)));
    xyz = kron(ones(size(zz)),xy)+kron(zz,ones(size(xy)));
    
    indexInMask = find(xyz==indexInFull);
    
    if issparse(VOXEL_MASK)
      indexInMask = find(VOXEL_MASK(indexInMask, :));
    end

