% lyngby_global        - File defining global variables
%
%       script 
%
%       Global: DATATYPE	Datatype of values in the volume files
%               DISCRIM_TMASK   Sparse time masking matrix. Used for
%                               discrimination analyses
%               FILE_READING_TYPE  Either a number or a string
%                               denoting the kind of volume file, eg,
%                               'analyze' (new style), ANALYZE=1 (old
%                               style), CUSTOM=2, RAW=2
%               FILENAME_PATH	     Path to file
%               FILENAME_PATTERN     String with the filename pattern
%                                    example: 'volume%02d'
%                                    Not necessary if CUSTOM_FILEREADING
%               FILENAME_STARTINDEX  Start index 
%               NUM_SCANS       Total number of scans
%               NUM_VOXELS      3x1 vector with the number
%                               of voxels in each direction
%               OFFSET          Offset for the values in the volume
%               ORDERING        'xyz', 'yxz', ...
%               ORIENTATION     ['lr', 'pa', 'is']
%               ORIGIN          Vector denoting the centervoxel
%                               (anterior commisure) indexed from one 
%                               files
%               ROI_VOXELS	3x2 vector with begin and end
%                               voxel number, indexed from one.
%                               if [] then NUM_VOXELS should be used
%               SCALE           Scale for the values in the volume files
%               TIME_MASK       Sparse masking matrix
%                               Size (Masked x Full)
%               VOXEL_MASK      Sparse masking matrix to be applied 
%                               on the ROI Volume, Size (Full x Masked)
%               HDR_ENDIAN      Endian of the header file (if present)
%                                 e.g. for Analyze files
%               DATA_ENDIAN     Endian of the data file(s)
%
%       This script makes a number of variables global in scope.
%
%       See also LYNGBY, LYNGBY_INIT, LYNGBY_UI_GLOBAL,
%                LYNGBY_UI_VOXELMASK. 
%
% $Id: lyngby_global.m,v 1.14 2002/07/30 14:25:45 fnielsen Exp $

%		NUM_RUNS	Number of runs
%		NUM_SUBJECTS	Number of subjects



	global NUM_VOXELS ROI_VOXELS ORIGIN DATATYPE SCALE OFFSET

	global NUM_SCANS NUM_RUNS NUM_SUBJECTS VOXELDIM

	global TIME_MASK VOXEL_MASK DISCRIM_TMASK LOGFILENAME

	global FILE_READING_TYPE FILENAME_PATTERN FILENAME_PATH FILENAME_STARTINDEX

	global ORDERING ORIENTATION HDR_ENDIAN DATA_ENDIAN

        global UI_ON

	global FILENAME_WORKSPACE DEFAULT_SAVE_PATH PREPROC_LOG











