function V = lyngby_gmm_plot(mys, Sigmas, ps, arg1, arg2, arg3, arg4, ...
    arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, ...
    arg15, arg16, arg17, arg18, arg19, arg20, arg21, arg22)

% lyngby_gmm_plot      - Plot gaussian mixture model 
%
%	function V = lyngby_gmm_plot(mys, Sigmas, ps, ...
%           'PropertyName', 'PropertyValue')
%
%       Input:  mys      Centers of gaussians
%               Sigmas   (Co-)variances of gaussians
%               ps       Mixture parameters
%		Property:
%                  'Data'    Datapoints
%                  'Assign'  Assignment vector. Should be numbers 
%                            [ 1..Number of clusters] The datapoints
%                            will be plotted as '1', '2', ... If the
%                            assignment vector is shorter than 'Data'
%                            then the last datapoints is plotted as
%                            'x'

% cvs : $Id: lyngby_gmm_plot.m,v 1.1 1998/09/03 12:30:35 fnielsen Exp $ 
%       $Revision: 1.1 $

    % Number of gaussians, and dimension
    [K, d] = size(mys);
    
    % default values
    X = [];
    assign = [];
    
    % Parse Properties
    n = 1;
    while n <= nargin-3
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'data')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if size(arg, 2) == d
	  X = arg;
	  [rX, cX] = size(X);
	else
	  error(sprintf(['Argument to ''Data'' should have ' ...
	      'the same dimension as mys'], arg));
	end

      elseif strcmp(arg, 'assign')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	assign = arg;

      else
	error('Invalid property');
      end
      n = n + 1;
    end

    

    if d >= 2 

      [U, S, V] = svd(mys);
      myProj = mys * V(:,1:2);
      
      plot(myProj(:,1),myProj(:,2), 'o');
      
      for c = 1:K
	Sigma = reshape(Sigmas(c,:),d,d); 
	if isfinite(cond(Sigma))
	  vol = sqrt(det(Sigma)^(1/d));
	  lyngby_circle(myProj(c,1),myProj(c,2), vol)
	end
      end
      
      if ~isempty(X)
	
	XProj = X * V(:,1:2);

	hold on
	if ~isempty(assign)
	  for r = 1:length(assign)
	    text(XProj(r,1),XProj(r,2), sprintf('%d', assign(r)));
	  end
	  for r = (length(assign)+1) : size(X,1)
	    text(XProj(r,1),XProj(r,2), 'x');
	  end
	else
	  plot(XProj(:,1),XProj(:,2), 'x');
	end
	hold off
      end

      V = V(:,1:2);
      
    end













