function x = lyngby_idf_beta(P, a, b)

% lyngby_idf_beta      - Inverse beta culumative probability function 
%
%       function x = lyngby_idf_beta(P, a, b)
%
%       Input:  P   Probability function
%               a   first parameter
%               b   second parameter
%
%       Output: x   inverse value
%
%       Inverse beta cumulative probability function
%
%       See also: LYNGBY_CDF_BETA, LYNGBY_PDF_BETA, LYNGBY_PDF_GAUSS

% cvs:  $Id: lyngby_idf_beta.m,v 1.1 2000/05/09 18:06:57 fnielsen Exp $
%       $Revision: 1.1 $

    maxiter = 100;

    x1 = 0;
    x2 = 1;

    for e = 1:maxiter
      x = (x1+x2)/2;
      Piter = lyngby_cdf_beta(x, a, b);
      if Piter <= P
        x1 = x;
      else
        x2 = x;
      end
    end














