function z = lyngby_idf_gauss(P, my, sigma2)

% lyngby_idf_gauss     - Inverse cumulated Gaussian distribution
%
%       z = lyngby_idf_gauss(P)
%
%       Input:  P    Lower tail area. Scalar, vector or matrix
%
%       Computes the inverse of the lower tail cumulated Gaussian
%       distribution. This is done with the inverse error function. 
%
%       The output is equivalent to the z-score.
%
%       Example:
%         lyngby_idf_gauss([0.95 0.99 0.999])
%        
%       See also LYNGBY, LYNGBY_IDF_T, LYNGBY_CDF_GAUSS,
%                LYNGBY_PDF_GAUSS. 
%
% $Id: lyngby_idf_gauss.m,v 1.2 2003/05/22 18:13:19 fnielsen Exp $



    % Check input arguments
    if nargin ~= 1
      error('Wrong number of input arguments')
    end


    z = sqrt(2) * erfinv(2*P - 1);
