function x = lyngby_idf_t(dof, F)

% lyngby_idf_t         - Inverted Student t distribution
%
%       function x = lyngby_idf_t(dof, F)
%
%       Input:  dof   Degrees of freedom
%               F     Fractile, ie. lower tail area of distribution
%
%       Output: x     Invers value
%
%       Inverted function of the lower tail Student t distribution.
%       The function computes x by bisection and calls to lyngby_cdf_t
%
%       See also LYNGBY, LYNGBY_IDF_GAUSS, LYNGBY_CDF_T.
%
% $Id: lyngby_idf_t.m,v 1.2 2003/05/22 17:49:35 fnielsen Exp $


    MAXITER = 100;

    x1 = 0;
    x2 = 100;

    for e = 1:MAXITER
      x = (x1+x2)/2;
      Fiter = lyngby_cdf_t(x, dof);
      if Fiter <= F
	x1 = x;
      else
	x2 = x;
      end
    end





