function  B = lyngby_img_regclean(R, threshold)

% lyngby_img_regclean  - cleaning of image
%
%       function  B = lyngby_img_regclean(R, threshold)
%
%       Input:  R          Labeled image
%               threshold  Determines smallest region size to exclude
%      
%       Output: B          Binary image
%
%       This function take a labeled image and construct a binary
%       image, where regions with the number of elements larger than
%       "threshold" is marked.
%
%       See also: lyngby_img_regident

% cvs : $Id: lyngby_img_regclean.m,v 1.2 1999/05/27 21:04:19 fnielsen Exp $
%       $Revision: 1.2 $

    if nargin < 2
      threshold = 1;
    end

    % Compute size of clusters
    nRegions = max(R(:));
    sizes = zeros(nRegions,1);
    for n = 1:nRegions
      sizes(n) = sum(R(:)==n);
    end

    B = zeros(size(R));
    for n = 1:nRegions
      B(find(R==n & sizes(n)>threshold)) = 1;
    end
    
    





