function Tmask = lyngby_index2tmask(Indices, times, itype)

% lyngby_index2tmask   - Return time mask from indices
%
%	function Tmask = lyngby_index2tmask(Indices, times, itype)
%
%       Input:  Indices   Indices for all timesmaples that will be in
%                         the masked sequence
%               times     Number of timepoints in the unmasked sequence
%               itype     (Optional) [ {1} | 0 ]  Indicator for one-
%                         or zero-indexed
%
%       Output: Tmask     A time mask (a sparse matrix)
%
%	See also LYNGBY, LYNGBY_TMASK2INDEX, LYNGBY_INDEX2VMASK.
% 
% $Id: lyngby_index2tmask.m,v 1.3 2004/06/01 12:26:54 fnielsen Exp $


    if nargin < 3
      itype = 1;
    end
    
    nIndex = length(Indices);
    Tmask = sparse(1:nIndex, Indices+(1-itype), ones(nIndex,1), nIndex, times);






