function Vmask = lyngby_index2vmask(Indices, voxels, itype)

% lyngby_index2vmask   - Return voxel from indices
%
%	function Vmask = lyngby_index2vmask(Indices, voxels, itype)
%
%       Input:  Indices   Indices for all voxels that will be in the
%                         masked image
%		voxels    Number of voxels 
%               itype     (Optional) [ {1} | 0 ]  
%
%       Output: Vmask     A voxel mask (a sparse matrix)
%
%	See also: lyngby_vmask2index, lyngby_mask2full,
%	          lyngby_full2mask

% cvs : $Id: lyngby_index2vmask.m,v 1.2 1998/03/27 17:40:03 fnielsen Exp $
%       $Revision: 1.2 $

    if nargin < 3
      itype = 1;
    end
    
    nIndex = length(Indices);
    Vmask = sparse(Indices+(1-itype), 1:nIndex, ones(nIndex,1), voxels, nIndex);







