function lyngby_init();

% lyngby_init          - Initialize the global variables
%
%	function lyngby_init();
%
%	Will setup the global variables from lyngby_global and call a 
%	user defined 'data_init' function if it exists.
%
%	See also LYNGBY_GLOBAL, LYNGBY_UI_MAIN

% cvs : $Id: lyngby_init.m,v 1.12 2001/07/19 08:07:21 mgl Exp $
%       $Revision: 1.12 $

	lyngby_global

	NUM_VOXELS = [];
	ROI_VOXELS = [];
	ORIGIN = [];

	DATATYPE = 'float32';
	SCALE = 1;
	OFFSET = 0;
	VOXELDIM = [0.002 0.002 0.002];
	
	NUM_SCANS = [];
	NUM_RUNS = 0;   % Was commented out for some reason... Use
                        % as flag for checking if set...
	NUM_SUBJECTS = 1;

	TIME_MASK = 1;
	VOXEL_MASK = 1;
	DISCRIM_TMASK = 1;
	
	FILE_READING_TYPE = 1;
	FILENAME_PATTERN = 'file%02d';
	FILENAME_PATH = '';
	FILENAME_STARTINDEX = 1;
	FILENAME_WORKSPACE = 'lyngby_workspace.mat';
	DEFAULT_SAVE_PATH = '~home/';
	
	ORDERING = 'xyz';
	ORIENTATION = ['lr', 'pa', 'is'];

	HDR_ENDIAN = 'big';       % [ {'big'}, 'small' ]
	DATA_ENDIAN = 'ieee-be';  % [ {'ieee-be'}, 'ieee-le' ] 
	
        LOGFILENAME='';
        
	UI_ON = 0;
	
	dir = pwd;
	initpath = which('data_init');
	if exist('data_init') == 2
	  eval('data_init;');	% eval is necessary
	  lyngby_ui_message(['The current lyngby working directory is: ', dir ...
			     ' And the data_init.m file used is the' ...
			     ' first one on the following list: ', initpath]);
	else
	  lyngby_ui_message(['Unable to find/open a data_init.m ' ...
			     'file for this data, so no loading defaults ' ...
			     'specific for this dataset will be specified. ' ...
			     'If this is incorrect, ensure that the ' ... 
			     'data_init.m file exists in the correct ' ...
			     'directory (i.e. in the same directory as ' ...
			     'the data) and that the permissions ' ...
			     'allow it to be read. ' ...
			     'Current lyngby working directory: ', dir]);

	end
