function y = lyngby_invlogistic(x)

% lyngby_invlogistic   - Inverse logistic function
%
%       y = lyngby_invlogitic(x)
%
%       Input:  x   Matrix, vector or scalar
% 
%       Output: y   Transformed values
%
%       The inverse function of the logistic function
%
%                     y = - log(1./x - 1)
%
%       See also LYNGBY, LYNGBY_NN_CSOFTMAX.  
%
% $Id: lyngby_invlogistic.m,v 1.1 2003/02/11 17:11:04 fnielsen Exp $

    y = - log(1./x - 1);
