function lyngby_km_plot_dist(assign, centersim) 

% lyngby_km_plot_dist  - Plot summary of cluster center similarity
%
%       function lyngby_km_plot_dist(assign, centersim)
%
%       Input:  assign       Assignment vector
%               centersim    Cluster center similarity vector
%
%       Plot the cluster center similarity with a boxplot. The extreme
%       limits in the box plot are the minimum and maximum, the middle
%       the mean and the limits of the box are the standard deviation.
%
%       Example:
%         load iris.txt
%         [centers, assign] = lyngby_km_main(iris, 'type', 'mean', 
%            'standardization', 'std', 'clusters', 3, 'init', 'random');
%         centersim = lyngby_km_centersim(iris, centers, assign,
%            'similarity', 'corrcoef');
%         lyngby_km_plot_dist(assign, centersim)
%
%       Ref: Balslev et al. (2002), Hum Brain Mapp 15:135+, figure 5.
%
%       See also LYNGBY, LYNGBY_KM_MAIN, LYNGBY_KM_CENTERSIM,
%                LYNGBY_KM_PLOT_SCAT, LYNGBY_PLOT_BOXPLOT. 
%
% $Id: lyngby_km_plot_dist.m,v 1.2 2003/01/30 11:50:48 fnielsen Exp $



    nClusters = max(assign);
    
    for n= 1:nClusters
      index = find(assign == n);
      m(n) = mean(centersim(index));
      s(n) = std(centersim(index));
      ma(n) = max(centersim(index));
      mi(n) = min(centersim(index));
    end
    
    lyngby_plot_boxplot(1:nClusters, m, m-s, m+s, mi, ma);

    set(gca, 'xtick', 1:nClusters)
    
    title('Cluster center similarity');
    xlabel('Cluster')
    ylabel('Min, mean-std, mean, mean+std, max')
    
    legend off
