function Z = lyngby_kronadd(X,Y)

% lyngby_kronadd		- Kronecker add
%
%	function Z = lyngby_kronadd(X,Y)
%
%	Input:	X, Y:	Matrix
%
%	Output:	Z:	Matrix, kronecker sum (not product)

%	Date		Author		Version
%	1995-05-08	fnielsen	Initial version
%	1996-11-20	fnielsen	femarized

% cvs :  $Revision: 1.1.1.1 $

	[Nxr, Nxc] = size(X);
	[Nyr, Nyc] = size(Y);

	Z = kron(X, ones(Nyr,Nyc)) + kron(ones(Nxr,Nxc), Y);




