function [Prob,D] = lyngby_ks_main(P,X, dropedge, tol)

% lyngby_ks_main       - Kolmogorov Smirnov test
%
%       function [Prob,D] = lyngby_ks_main(P,X, dropedge, tol)
%
%       See also: lyngby_ks_test, lyngby_ks_prob

% cvs : $Id: lyngby_ks_main.m,v 1.11 1999/07/09 13:58:57 fnielsen Exp $
%       $Revision: 1.11 $    


    [rX, cX] = size(X);


    Prob = zeros(1, cX);
    D    = zeros(1, cX);
    
    [ion,ioff] = lyngby_splitonoff(P,dropedge);
    
    lyngby_log(sprintf('Computing KS-map: %i / %i', 1, cX));

    for v = 1:cX
      if lyngby_mod(v,10)==0,
	lyngby_log(sprintf('Computing KS-map: %i /%i', v, cX));
      end;
      y = X(:,v);
      [p, d]  = lyngby_ks_test(y(ion),y(ioff),tol);
      Prob(v) = 1-p; 
      D(v)    = d;
    end


